/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.network.img;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import net.minecraft.util.Tuple;
import worldcontrolteam.worldcontrol.network.img.IImageGrabber;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class ImageGrabber
implements Runnable,
IImageGrabber {
    private HashMap<String, BufferedImage> loaded = new HashMap();
    private BlockingQueue<Tuple<String, String>> toDownload = new ArrayBlockingQueue<Tuple<String, String>>(20);
    private Thread me = new Thread((Runnable)this, "WC image downloader");

    private BufferedImage downloadImage(String trustedUrl) throws IOException {
        URL url = new URL(trustedUrl);
        return ImageIO.read(url.openStream());
    }

    public ImageGrabber() {
        this.me.setDaemon(true);
        this.me.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            Tuple<String, String> to_get;
            try {
                to_get = this.toDownload.take();
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                WCUtility.info("Beginning image download: " + (String)to_get.func_76341_a());
                BufferedImage i = this.downloadImage((String)to_get.func_76341_a());
                WCUtility.info("Download finished.");
                HashMap<String, BufferedImage> hashMap = this.loaded;
                synchronized (hashMap) {
                    this.loaded.put((String)to_get.func_76340_b(), i);
                }
            }
            catch (IOException e) {
                WCUtility.info("Failed to download from url: " + (String)to_get.func_76341_a() + " because: " + e.getMessage());
            }
        }
    }

    @Override
    public void beginDownload(String trustedUrl, String key) {
        this.toDownload.add((Tuple<String, String>)new Tuple((Object)trustedUrl, (Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage retrieveDownloadedImage(String key) {
        HashMap<String, BufferedImage> hashMap = this.loaded;
        synchronized (hashMap) {
            if (this.loaded.containsKey(key)) {
                BufferedImage i = this.loaded.get(key);
                this.loaded.remove(key);
                return i;
            }
        }
        return null;
    }
}

