/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.tesla;

import java.util.List;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.compat.StringWrapper;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class TeslaPowerCard
extends ItemBaseCard {
    public TeslaPowerCard() {
        super("tesla_power_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        BlockPos pos;
        if (card.func_77942_o() && world.func_175625_s(pos = NBTUtils.getBlockPos(card.func_77978_p())).hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN)) {
            ITeslaHolder power = (ITeslaHolder)world.func_175625_s(pos).getCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
            card.func_77978_p().func_74772_a("stored_power", power.getStoredPower());
            card.func_77978_p().func_74772_a("capacity", power.getCapacity());
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        if (card.func_77942_o()) {
            long capacity = card.func_77978_p().func_74763_f("capacity");
            long storedPower = card.func_77978_p().func_74763_f("stored_power");
            list.add(new StringWrapper(WCUtility.translateFormatted("forge_energy", storedPower)));
            list.add(new StringWrapper(WCUtility.translateFormatted("forge_free", capacity - storedPower)));
            list.add(new StringWrapper(WCUtility.translateFormatted("forge_stored", capacity)));
            list.add(new StringWrapper(WCUtility.translateFormatted("fill_ratio", Math.round((float)storedPower / (float)capacity * 100.0f))));
        }
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return WCUtility.GREEN;
    }
}

