/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.industrialcraft2.items;

import ic2.api.reactor.IReactor;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.compat.StringWrapper;
import worldcontrolteam.worldcontrol.crossmod.industrialcraft2.ReactorUtils;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class IC2ReactorCard
extends ItemBaseCard {
    public IC2ReactorCard() {
        super("ic2_reactor_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        BlockPos pos;
        IReactor reactor;
        if (card.func_77942_o() && (reactor = ReactorUtils.getReactorAt(world, pos = NBTUtils.getBlockPos(card.func_77978_p()))) != null) {
            card.func_77978_p().func_74768_a("heat", reactor.getHeat());
            card.func_77978_p().func_74768_a("max_heat", reactor.getMaxHeat());
            card.func_77978_p().func_74757_a("reactor_powered_b", ReactorUtils.isProducing(world, pos));
            card.func_77978_p().func_74768_a("output", (int)Math.round(reactor.getReactorEUEnergyOutput()));
            boolean isSteam = false;
            IInventory inventory = (IInventory)reactor;
            int slotCount = inventory.func_70302_i_();
            int timeLeft = 0;
            for (int i = 0; i < slotCount; ++i) {
                ItemStack rStack = inventory.func_70301_a(i);
                if (rStack.func_190926_b()) continue;
                timeLeft = Math.max(timeLeft, ReactorUtils.getNuclearCellTimeLeft(rStack));
            }
            card.func_77978_p().func_74768_a("time_left", timeLeft * (isSteam ? 20 : reactor.getTickRate()) / 20);
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        if (card.func_77942_o()) {
            String text;
            StringWrapper line = new StringWrapper();
            line.textLeft = WCUtility.translateFormattedR("info_panel_heat", showLabels, card.func_77978_p().func_74762_e("heat"));
            list.add(line);
            line = new StringWrapper();
            line.textLeft = WCUtility.translateFormatted("info_panel_max_heat", card.func_77978_p().func_74762_e("max_heat"));
            list.add(line);
            line = new StringWrapper();
            line.textLeft = WCUtility.translateFormatted("info_panel_melting", card.func_77978_p().func_74762_e("max_heat") * 85 / 100);
            list.add(line);
            line = new StringWrapper();
            line.textLeft = WCUtility.translateFormatted("info_panel_output", card.func_77978_p().func_74762_e("output"));
            list.add(line);
            int timeLeft = card.func_77978_p().func_74762_e("time_left");
            int hours = timeLeft / 3600;
            int minutes = timeLeft % 3600 / 60;
            int seconds = timeLeft % 60;
            line = new StringWrapper();
            String time = String.format("%d:%02d:%02d", hours, minutes, seconds);
            line.textLeft = WCUtility.translateFormatted("info_panel_time_remaining", time);
            list.add(line);
            int txtColor = 0;
            boolean reactorPowered = card.func_77978_p().func_74767_n("reactor_powered_b");
            if (reactorPowered) {
                txtColor = 65280;
                text = WCUtility.translateFormatted("info_panel_on", new Object[0]);
            } else {
                txtColor = 0xFF0000;
                text = WCUtility.translateFormatted("info_panel_off", new Object[0]);
            }
            if (list.size() > 0) {
                StringWrapper firstLine = list.get(0);
                firstLine.textRight = text;
                firstLine.colorRight = txtColor;
            } else {
                line = new StringWrapper();
                line.textLeft = text;
                line.colorLeft = txtColor;
                list.add(line);
            }
        }
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return WCUtility.WHITE;
    }
}

