/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.model.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModel;
import org.apache.commons.lang3.tuple.Pair;
import worldcontrolteam.worldcontrol.client.model.util.ModelUtil;
import worldcontrolteam.worldcontrol.client.model.util.TextureArray;

public abstract class SimpleBlockModel
implements IModel {
    protected List<ResourceLocation> textures;

    public SimpleBlockModel(List<ResourceLocation> textures) {
        this.textures = textures;
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public static abstract class Baked
    implements IBakedModel {
        private final VertexFormat fmt;
        private Map<TextureArray, List<BakedQuad>> cache = new HashMap<TextureArray, List<BakedQuad>>();
        protected Map<ResourceLocation, TextureAtlasSprite> sprites = new HashMap<ResourceLocation, TextureAtlasSprite>();

        public Baked(VertexFormat fmt, SimpleBlockModel parent, Function<ResourceLocation, TextureAtlasSprite> func) {
            this.fmt = fmt;
            Iterator<ResourceLocation> iterator = parent.getTextures().iterator();
            while (iterator.hasNext()) {
                ResourceLocation i_;
                ResourceLocation i = i_ = iterator.next();
                this.sprites.put(i, func.apply(i));
            }
        }

        public abstract TextureArray getTextureArray(@Nullable IBlockState var1);

        public List<BakedQuad> func_188616_a(@Nullable IBlockState iBlockState, @Nullable EnumFacing enumFacing, long l) {
            return this.cache.computeIfAbsent(this.getTextureArray(iBlockState), textureArray -> ModelUtil.makeCuboid(this.fmt, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, null, textureArray, 0));
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.getTextureArray(null).getParticleTexture();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            if (ModelUtil.BLOCK_TRANSFORMS.containsKey(type)) {
                return Pair.of((Object)this, (Object)ModelUtil.BLOCK_TRANSFORMS.get(type).getMatrix());
            }
            return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
        }
    }
}

