/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.gui.features;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import worldcontrolteam.worldcontrol.network.ChannelHandler;
import worldcontrolteam.worldcontrol.network.messages.PacketUpdateHowlerAlarm;
import worldcontrolteam.worldcontrol.tileentity.TileEntityHowlerAlarm;
import worldcontrolteam.worldcontrol.utils.WCConfig;

@SideOnly(value=Side.CLIENT)
public class HowlerAlarmSlider
extends GuiButton {
    private static final String TEXTURE_FILE = "worldcontrol:textures/gui/gui_howler_alarm.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("worldcontrol:textures/gui/gui_howler_alarm.png");
    public float sliderValue;
    public boolean dragging;
    private int minValue = 0;
    private int maxValue = 256;
    private int step = 8;
    private String label;
    private TileEntityHowlerAlarm alarm;

    public HowlerAlarmSlider(int id, int x, int y, String label, TileEntityHowlerAlarm alarm) {
        super(id, x, y, 107, 16, label);
        this.alarm = alarm;
        this.dragging = false;
        this.label = label;
        if (alarm.func_145831_w().field_72995_K) {
            this.maxValue = WCConfig.maxAlarmRange;
        }
        int currentRange = alarm.getRange();
        if (alarm.func_145831_w().field_72995_K && currentRange > this.maxValue) {
            currentRange = this.maxValue;
        }
        this.sliderValue = ((float)currentRange - (float)this.minValue) / (float)(this.maxValue - this.minValue);
        this.field_146126_j = I18n.func_135052_a((String)label, (Object[])new Object[]{this.getNormalizedValue()});
    }

    private int getNormalizedValue() {
        return (this.minValue + (int)Math.floor((float)(this.maxValue - this.minValue) * this.sliderValue)) / this.step * this.step;
    }

    private void setSliderPos(int targetX) {
        this.sliderValue = (float)(targetX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
        if (this.sliderValue < 0.0f) {
            this.sliderValue = 0.0f;
        }
        if (this.sliderValue > 1.0f) {
            this.sliderValue = 1.0f;
        }
        int newValue = this.getNormalizedValue();
        if (this.alarm.getRange() != newValue) {
            this.alarm.setRange(newValue);
            ChannelHandler.network.sendToServer((IMessage)new PacketUpdateHowlerAlarm(newValue, "default", this.alarm.func_174877_v()));
        }
        this.field_146126_j = I18n.func_135052_a((String)this.label, (Object[])new Object[]{newValue});
    }

    public void func_191745_a(Minecraft minecraft, int targetX, int targetY, float f) {
        if (this.field_146125_m) {
            minecraft.field_71446_o.func_110577_a(TEXTURE_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.dragging) {
                this.setSliderPos(targetX);
            }
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 131, 0, 8, 16);
            minecraft.field_71466_p.func_78276_b(this.field_146126_j, this.field_146128_h, this.field_146129_i - 12, 0x404040);
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int targetX, int j) {
        if (super.func_146116_c(minecraft, targetX, j)) {
            this.setSliderPos(targetX);
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int i, int j) {
        super.func_146118_a(i, j);
        this.dragging = false;
    }
}

