/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import worldcontrolteam.worldcontrol.CommonProxy;
import worldcontrolteam.worldcontrol.api.card.compat.IProviderCard;
import worldcontrolteam.worldcontrol.client.AlarmAudioLoader;
import worldcontrolteam.worldcontrol.client.model.infopanel.ModelLoaderInfoPanel;
import worldcontrolteam.worldcontrol.client.render.RenderHeatMonitor;
import worldcontrolteam.worldcontrol.client.render.RenderInfoPanel;
import worldcontrolteam.worldcontrol.init.IModelRegistrar;
import worldcontrolteam.worldcontrol.init.Translator;
import worldcontrolteam.worldcontrol.init.WCContent;
import worldcontrolteam.worldcontrol.inventory.InventoryItem;
import worldcontrolteam.worldcontrol.network.img.IImageGrabber;
import worldcontrolteam.worldcontrol.network.img.ImageGrabber;
import worldcontrolteam.worldcontrol.screen.img.ScreenImageMarshaller;
import worldcontrolteam.worldcontrol.tileentity.TileEntityBaseReactorHeatMonitor;
import worldcontrolteam.worldcontrol.tileentity.TileEntityHowlerAlarm;
import worldcontrolteam.worldcontrol.tileentity.TileEntityInfoPanel;
import worldcontrolteam.worldcontrol.utils.WCUtility;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static Translator translator = new Translator.ClientTranslator();
    private ImageGrabber grabber;

    @Override
    public Translator getSidedTranslator() {
        return translator;
    }

    @Override
    public IImageGrabber getImageGrabber() {
        return this.grabber;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderInfoPanel());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBaseReactorHeatMonitor.class, (TileEntitySpecialRenderer)new RenderHeatMonitor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInfoPanel.class, (TileEntitySpecialRenderer)new RenderInfoPanel());
        AlarmAudioLoader.checkAndCreateFolders(event.getModConfigurationDirectory());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new AlarmAudioLoader.TextureSetting());
    }

    @Override
    public void init() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            InventoryItem inv;
            if (tintIndex == 1 && !(inv = new InventoryItem(stack)).func_70301_a(0).func_190926_b() && inv.func_70301_a(0).func_77973_b() instanceof IProviderCard) {
                return ((IProviderCard)inv.func_70301_a(0).func_77973_b()).getCardColor();
            }
            return -1;
        }, new Item[]{WCContent.REMOTE_PANEL});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? WCUtility.getTileEntity(world, pos, TileEntityHowlerAlarm.class).map(TileEntityHowlerAlarm::getColor).orElse(0xFFFFFF) : 0xFFFFFF, new Block[]{WCContent.HOWLER_ALARM});
        this.grabber = new ImageGrabber();
        ScreenImageMarshaller.INSTANCE.initGL();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        WCContent.BLOCKS.stream().filter(b -> b instanceof IModelRegistrar).map(b -> (Block)((IModelRegistrar)b)).forEach(b -> ((IModelRegistrar)b).registerModels(event));
        WCContent.ITEMS.stream().filter(i -> i instanceof IModelRegistrar).map(i -> (Item)((IModelRegistrar)i)).forEach(i -> ((IModelRegistrar)i).registerModels(event));
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent event) {
    }
}

