/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.api.screen.predefs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.api.card.compat.IProviderCard;
import worldcontrolteam.worldcontrol.api.card.compat.StringWrapper;
import worldcontrolteam.worldcontrol.api.screen.IScreenElement;

public class ScreenElementProviderCard
implements IScreenElement {
    private final IProviderCard card;
    private List<StringWrapper> joinedData;
    boolean showingLabels = false;
    int colorOverride = -1;

    public ScreenElementProviderCard(IProviderCard card) {
        this.card = card;
        this.joinedData = new ArrayList<StringWrapper>();
    }

    @Override
    public void onCardUpdate(World world, ItemStack newItemStack) {
        this.joinedData.clear();
        this.card.getStringData(this.joinedData, 0, newItemStack, this.showingLabels);
    }

    @Override
    public void setContext(IScreenElement.EnumScreenContext ctx, boolean showLabels) {
        this.showingLabels = showLabels;
        if (ctx == IScreenElement.EnumScreenContext.REMOTE_PANEL) {
            this.colorOverride = 437988;
        }
    }

    @Override
    public void draw(int sizeX, int sizeY, float partialTicks) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int maxlen = 1;
        for (StringWrapper sw : this.joinedData) {
            int len = (sw.textLeft != null ? fontRenderer.func_78256_a(sw.textLeft) : 8) + (sw.textRight != null ? fontRenderer.func_78256_a(sw.textRight) + 4 : 8) + (sw.textCenter != null ? fontRenderer.func_78256_a(sw.textCenter) + 4 : 8);
            maxlen = Math.max(maxlen, len);
        }
        double scaleFactor = (double)sizeX / (double)maxlen;
        if ((double)(this.joinedData.size() * 10) * scaleFactor > (double)sizeY) {
            scaleFactor = (float)sizeY / (float)(this.joinedData.size() * 10);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)scaleFactor, (double)scaleFactor, (double)0.0);
        sizeX = (int)((double)sizeX / scaleFactor);
        int row = 0;
        for (StringWrapper panelString : this.joinedData) {
            if (panelString.textLeft != null) {
                fontRenderer.func_78276_b(panelString.textLeft, 2, row * 10, this.colorOverride == -1 ? panelString.colorLeft : this.colorOverride);
            }
            if (panelString.textCenter != null) {
                fontRenderer.func_78276_b(panelString.textCenter, (sizeX - fontRenderer.func_78256_a(panelString.textCenter)) / 2, row * 10, this.colorOverride == -1 ? panelString.colorCenter : this.colorOverride);
            }
            if (panelString.textRight != null) {
                fontRenderer.func_78276_b(panelString.textRight, sizeX - fontRenderer.func_78256_a(panelString.textRight), row * 10, this.colorOverride == -1 ? panelString.colorRight : this.colorOverride);
            }
            if (row++ * 10 <= sizeY) continue;
            return;
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public double getSizeY(int sizeX) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int maxlen = 1;
        for (StringWrapper sw : this.joinedData) {
            int len = (sw.textLeft != null ? fontRenderer.func_78256_a(sw.textLeft) : 8) + (sw.textRight != null ? fontRenderer.func_78256_a(sw.textRight) + 4 : 8) + (sw.textCenter != null ? fontRenderer.func_78256_a(sw.textCenter) + 4 : 8);
            maxlen = Math.max(maxlen, len);
        }
        double scaleFactor = (double)sizeX / (double)maxlen;
        int row = this.joinedData.size();
        return (double)(row * 10 + 20) * scaleFactor;
    }
}

