/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.gui;

import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.network.PacketHandler;
import buildcraft.additionalpipes.network.message.MessageTelePipeData;
import buildcraft.additionalpipes.pipes.PipeBehaviorTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.transport.tile.TilePipeHolder;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerTeleportPipe
extends ContainerBC_Neptune {
    public int connectedPipes = 0;
    private int ticks = 0;
    public PipeBehaviorTeleport pipe;
    private int freq;
    private byte state;
    private boolean isPublic;
    private boolean isSendingPipe;
    private int originalfreq;

    public ContainerTeleportPipe(EntityPlayer player, PipeBehaviorTeleport pipe) {
        super(player);
        this.pipe = pipe;
        this.state = (byte)-1;
        this.isPublic = !pipe.isPublic;
        this.freq = -1;
        this.isSendingPipe = pipe.canSend();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ArrayList<ITeleportPipe> connectedPipes = TeleportManager.instance.getConnectedPipes(pipe, !this.isSendingPipe, this.isSendingPipe);
            int[] locations = new int[connectedPipes.size() * 3];
            for (int i = 0; i < connectedPipes.size() && i < 9; ++i) {
                ITeleportPipe connectedPipe = (ITeleportPipe)connectedPipes.get(i);
                locations[3 * i] = connectedPipe.getContainer().func_174877_v().func_177958_n();
                locations[3 * i + 1] = connectedPipe.getContainer().func_174877_v().func_177956_o();
                locations[3 * i + 2] = connectedPipe.getContainer().func_174877_v().func_177952_p();
            }
            MessageTelePipeData message = new MessageTelePipeData(pipe.getPos(), locations, pipe.ownerUUID, pipe.ownerName);
            PacketHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
            this.originalfreq = pipe.getFrequency();
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        TilePipeHolder tile = this.pipe.getContainer();
        if (tile.func_145831_w().func_175625_s(tile.func_174877_v()) != tile) {
            return false;
        }
        return !(entityplayer.func_70092_e((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5) > 64.0);
    }

    public void func_75142_b() {
        super.func_75142_b();
        int connectedPipesNew = this.connectedPipes;
        if (this.ticks % 20 == 0) {
            this.ticks = 0;
            Log.debug("Old connected:" + connectedPipesNew);
            connectedPipesNew = TeleportManager.instance.getConnectedPipes(this.pipe, !this.isSendingPipe, this.isSendingPipe).size();
            Log.debug("New connected:" + connectedPipesNew);
        }
        ++this.ticks;
        for (IContainerListener crafter : this.field_75149_d) {
            if (this.freq != this.pipe.getFrequency()) {
                crafter.func_71112_a((Container)this, 0, this.pipe.getFrequency());
            }
            if (this.state != this.pipe.state) {
                crafter.func_71112_a((Container)this, 1, (int)this.pipe.state);
            }
            if (connectedPipesNew != this.connectedPipes) {
                crafter.func_71112_a((Container)this, 2, connectedPipesNew);
            }
            if (this.isPublic == this.pipe.isPublic) continue;
            crafter.func_71112_a((Container)this, 3, this.pipe.isPublic ? 1 : 0);
        }
        this.state = this.pipe.state;
        this.freq = this.pipe.getFrequency();
        this.isPublic = this.pipe.isPublic;
        this.connectedPipes = connectedPipesNew;
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.pipe.setFrequency(j);
                break;
            }
            case 1: {
                this.pipe.state = (byte)j;
                break;
            }
            case 2: {
                this.connectedPipes = j;
                break;
            }
            case 3: {
                this.pipe.isPublic = j == 1;
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            TeleportManager.instance.remove(this.pipe, this.originalfreq);
            TeleportManager.instance.add(this.pipe, this.freq);
        }
    }
}

