/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class JsonToNBTFixed {
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final String string;
    private int cursor;

    @VisibleForTesting
    JsonToNBTFixed(String stringIn) {
        this.string = stringIn;
    }

    public static NBTTagCompound getTagFromJson(String jsonString) throws NBTException {
        return new JsonToNBTFixed(jsonString).readSingleStruct();
    }

    @VisibleForTesting
    NBTTagCompound readSingleStruct() throws NBTException {
        NBTTagCompound nbttagcompound = this.readStruct();
        this.skipWhitespace();
        if (this.canRead()) {
            ++this.cursor;
            throw this.exception("Trailing data found");
        }
        return nbttagcompound;
    }

    protected String readKey() throws NBTException {
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected key");
        }
        return this.peek() == '\"' ? this.readQuotedString() : this.readString();
    }

    private NBTException exception(String message) {
        return new NBTException(message, this.string, this.cursor);
    }

    protected NBTBase readTypedValue() throws NBTException {
        this.skipWhitespace();
        String s = this.peek() == '\"' ? this.readQuotedString() : this.readString();
        if (s.isEmpty()) {
            throw this.exception("Expected value");
        }
        return this.type(s);
    }

    private NBTBase type(String stringIn) {
        try {
            if (FLOAT_PATTERN.matcher(stringIn).matches()) {
                return new NBTTagFloat(Float.parseFloat(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (BYTE_PATTERN.matcher(stringIn).matches()) {
                return new NBTTagByte(Byte.parseByte(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (LONG_PATTERN.matcher(stringIn).matches()) {
                return new NBTTagLong(Long.parseLong(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (SHORT_PATTERN.matcher(stringIn).matches()) {
                return new NBTTagShort(Short.parseShort(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (INT_PATTERN.matcher(stringIn).matches()) {
                return new NBTTagInt(Integer.parseInt(stringIn));
            }
            if (DOUBLE_PATTERN.matcher(stringIn).matches()) {
                return new NBTTagDouble(Double.parseDouble(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (DOUBLE_PATTERN_NOSUFFIX.matcher(stringIn).matches()) {
                return new NBTTagDouble(Double.parseDouble(stringIn));
            }
            if ("true".equalsIgnoreCase(stringIn)) {
                return new NBTTagByte(1);
            }
            if ("false".equalsIgnoreCase(stringIn)) {
                return new NBTTagByte(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new NBTTagString(stringIn);
    }

    private String readQuotedString() throws NBTException {
        int i = ++this.cursor;
        StringBuilder stringbuilder = null;
        boolean flag = false;
        while (this.canRead()) {
            char c0 = this.pop();
            if (flag) {
                if (c0 != '\\' && c0 != '\"') {
                    throw this.exception("Invalid escape of '" + c0 + "'");
                }
                flag = false;
            } else {
                if (c0 == '\\') {
                    flag = true;
                    if (stringbuilder != null) continue;
                    stringbuilder = new StringBuilder(this.string.substring(i, this.cursor - 1));
                    continue;
                }
                if (c0 == '\"') {
                    return stringbuilder == null ? this.string.substring(i, this.cursor - 1) : stringbuilder.toString();
                }
            }
            if (stringbuilder == null) continue;
            stringbuilder.append(c0);
        }
        throw this.exception("Missing termination quote");
    }

    private String readString() {
        int i = this.cursor;
        while (this.canRead() && this.isAllowedInKey(this.peek())) {
            ++this.cursor;
        }
        return this.string.substring(i, this.cursor);
    }

    protected NBTBase readValue() throws NBTException {
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected value");
        }
        char c0 = this.peek();
        if (c0 == '{') {
            return this.readStruct();
        }
        return c0 == '[' ? this.readList() : this.readTypedValue();
    }

    protected NBTBase readList() throws NBTException {
        return this.canRead(2) && this.peek(1) != '\"' && this.peek(2) == ';' ? this.readArrayTag() : this.readListTag();
    }

    protected NBTTagCompound readStruct() throws NBTException {
        this.expect('{');
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.skipWhitespace();
        while (this.canRead() && this.peek() != '}') {
            String s = this.readKey();
            if (s.isEmpty()) {
                throw this.exception("Expected non-empty key");
            }
            this.expect(':');
            nbttagcompound.func_74782_a(s, this.readValue());
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.exception("Expected key");
        }
        this.expect('}');
        return nbttagcompound;
    }

    private NBTBase readListTag() throws NBTException {
        this.expect('[');
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected value");
        }
        NBTTagList nbttaglist = new NBTTagList();
        byte i = -1;
        while (this.peek() != ']') {
            NBTBase nbtbase = this.readValue();
            byte j = nbtbase.func_74732_a();
            if (i < 0) {
                i = j;
            } else if (j != i) {
                throw this.exception("Unable to insert " + NBTBase.func_193581_j((int)j) + " into ListTag of type " + NBTBase.func_193581_j((int)i));
            }
            nbttaglist.func_74742_a(nbtbase);
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.exception("Expected value");
        }
        this.expect(']');
        return nbttaglist;
    }

    private NBTBase readArrayTag() throws NBTException {
        this.expect('[');
        char c0 = this.pop();
        this.pop();
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected value");
        }
        if (c0 == 'B') {
            return new NBTTagByteArray(this.readArray((byte)7, (byte)1));
        }
        if (c0 == 'L') {
            return new NBTTagLongArray(this.readArray((byte)12, (byte)4));
        }
        if (c0 == 'I') {
            return new NBTTagIntArray(this.readArray((byte)11, (byte)3));
        }
        throw this.exception("Invalid array type '" + c0 + "' found");
    }

    private <T extends Number> List<T> readArray(byte p_193603_1_, byte p_193603_2_) throws NBTException {
        ArrayList list = Lists.newArrayList();
        while (this.peek() != ']') {
            NBTBase nbtbase = this.readValue();
            byte i = nbtbase.func_74732_a();
            if (i != p_193603_2_) {
                throw this.exception("Unable to insert " + NBTBase.func_193581_j((int)i) + " into " + NBTBase.func_193581_j((int)p_193603_1_));
            }
            if (p_193603_2_ == 1) {
                list.add(((NBTPrimitive)nbtbase).func_150290_f());
            } else if (p_193603_2_ == 4) {
                list.add(((NBTPrimitive)nbtbase).func_150291_c());
            } else {
                list.add(((NBTPrimitive)nbtbase).func_150287_d());
            }
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.exception("Expected value");
        }
        this.expect(']');
        return list;
    }

    private void skipWhitespace() {
        while (this.canRead() && Character.isWhitespace(this.peek())) {
            ++this.cursor;
        }
    }

    private boolean hasElementSeparator() {
        this.skipWhitespace();
        if (this.canRead() && this.peek() == ',') {
            ++this.cursor;
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char expected) throws NBTException {
        this.skipWhitespace();
        boolean flag = this.canRead();
        if (flag && this.peek() == expected) {
            ++this.cursor;
        } else {
            throw new NBTException("Expected '" + expected + "' but got '" + (flag ? Character.valueOf(this.peek()) : "<EOF>") + "'", this.string, this.cursor + 1);
        }
    }

    protected boolean isAllowedInKey(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'A' && charIn <= 'Z' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == '-' || charIn == '.' || charIn == '+';
    }

    private boolean canRead(int p_193608_1_) {
        return this.cursor + p_193608_1_ < this.string.length();
    }

    boolean canRead() {
        return this.canRead(0);
    }

    private char peek(int p_193597_1_) {
        return this.string.charAt(this.cursor + p_193597_1_);
    }

    private char peek() {
        return this.peek(0);
    }

    private char pop() {
        return this.string.charAt(this.cursor++);
    }
}

