/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.energy;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.capabilities.energy.adapter.ElectricAdapter;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.item.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;

public class ElectricItemUtils {
    public static List<ElectricAdapter> electricItemsEquipped(EntityPlayer player) {
        ArrayList<ElectricAdapter> electrics = new ArrayList<ElectricAdapter>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ElectricAdapter adapter = ElectricAdapter.wrap(player.func_184582_a(slot));
            if (adapter == null) continue;
            electrics.add(adapter);
        }
        return electrics;
    }

    static List<ElectricAdapter> toElectricAdapters(NonNullList<ItemStack> itemStacks) {
        ArrayList<ElectricAdapter> electrics = new ArrayList<ElectricAdapter>();
        itemStacks.forEach(stack -> {
            ElectricAdapter adapter = ElectricAdapter.wrap(stack);
            if (adapter != null) {
                electrics.add(adapter);
            }
        });
        return electrics;
    }

    public static List<ElectricAdapter> electricItemsEquippedWithoutActive(EntityPlayer player, boolean skipForeignItems) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = player.func_184582_a(slot);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND && (player.func_184587_cr() && slot == MuseItemUtils.toHand(player.func_184600_cs()) || skipForeignItems && !(item instanceof IModularItem) && (item instanceof ItemTool || item instanceof ItemArmor))) continue;
            stacks.add((Object)stack);
        }
        return ElectricItemUtils.toElectricAdapters((NonNullList<ItemStack>)stacks);
    }

    public static int chargeEmulatedToolFromPlayerEnergy(EntityPlayer player, @Nonnull ItemStack emulatedTool) {
        int chargeAmount;
        int charge;
        if (player.field_70170_p.field_72995_K) {
            return 0;
        }
        ElectricAdapter adapter = ElectricAdapter.wrap(emulatedTool);
        if (adapter == null) {
            return 0;
        }
        int maxCharge = adapter.getMaxEnergyStored();
        if (maxCharge == (charge = adapter.getEnergyStored())) {
            return 0;
        }
        int playerEnergy = ElectricItemUtils.getPlayerEnergy(player);
        if (playerEnergy > maxCharge - charge) {
            adapter.receiveEnergy(maxCharge - charge, false);
            chargeAmount = ElectricItemUtils.drainPlayerEnergy(player, maxCharge - charge);
        } else {
            adapter.receiveEnergy(playerEnergy, false);
            chargeAmount = ElectricItemUtils.drainPlayerEnergy(player, playerEnergy);
        }
        return chargeAmount;
    }

    public static int getPlayerEnergy(EntityPlayer player) {
        int avail = 0;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += adapter.getEnergyStored();
        }
        return avail;
    }

    public static int getMaxPlayerEnergy(EntityPlayer player) {
        int avail = 0;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += adapter.getMaxEnergyStored();
        }
        return avail;
    }

    public static int drainPlayerEnergy(EntityPlayer player, int drainAmount) {
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return 0;
        }
        int drainleft = drainAmount;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquippedWithoutActive(player, true)) {
            if (drainleft <= 0) break;
            drainleft -= adapter.extractEnergy(drainleft, false);
        }
        return drainAmount - drainleft;
    }

    public static int givePlayerEnergy(EntityPlayer player, int rfToGive) {
        int rfLeft = rfToGive;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquippedWithoutActive(player, false)) {
            if (rfLeft <= 0) break;
            rfLeft -= adapter.receiveEnergy(rfLeft, false);
        }
        return rfToGive - rfLeft;
    }

    public static int getItemEnergy(@Nonnull ItemStack itemStack) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            return adapter.getEnergyStored();
        }
        return 0;
    }

    public static int getMaxItemEnergy(@Nonnull ItemStack itemStack) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            return adapter.getEnergyStored();
        }
        return 0;
    }

    public static int chargeItem(@Nonnull ItemStack itemStack, int chargeAmount) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            return adapter.receiveEnergy(chargeAmount, false);
        }
        return 0;
    }
}

