/*
 * Decompiled with CFR 0.152.
 */
package com.unnoen.unloader;

import com.unnoen.unloader.Config;
import com.unnoen.unloader.Unloader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class UnloadHandler {
    private int tickIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent tick) {
        if (tick.phase == TickEvent.Phase.END && ++this.tickIndex == Config.unloadCheck) {
            this.tickIndex = 0;
            Integer[] integerArray = DimensionManager.getIDs();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int dimension = integerArray[i];
                WorldServer worldServer = DimensionManager.getWorld((int)dimension);
                ChunkProviderServer provider = worldServer.func_72863_F();
                DimensionType providerType = DimensionManager.getProviderType((int)dimension);
                String dimensionName = "";
                if (providerType != null) {
                    dimensionName = providerType.func_186065_b();
                }
                for (String blacklistRegex : Config.blacklistDims) {
                    if (dimensionName.matches(blacklistRegex) || Integer.toString(dimension).matches(blacklistRegex) || worldServer.field_73011_w.func_186058_p().shouldLoadSpawn() || !ForgeChunkManager.getPersistentChunksFor((World)worldServer).isEmpty() || provider.func_73152_e() != 0 || !worldServer.field_73010_i.isEmpty() || !worldServer.field_72996_f.isEmpty() || !worldServer.field_147482_g.isEmpty()) continue;
                    try {
                        worldServer.func_73044_a(true, null);
                    }
                    catch (MinecraftException e) {
                        Unloader.logger.error("Caught an exception while saving all chunks:", (Throwable)e);
                    }
                    finally {
                        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)worldServer));
                        worldServer.func_73041_k();
                        DimensionManager.setWorld((int)dimension, null, (MinecraftServer)worldServer.func_73046_m());
                    }
                }
            }
        }
    }
}

