/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.base.Preconditions;
import openmods.Log;
import openmods.api.IResultListener;
import openmods.asm.MethodMatcher;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class PreWorldRenderHookVisitor
extends ClassVisitor {
    private static boolean active;
    private static Runnable hook;
    private final IResultListener listener;
    private final MethodMatcher modifiedMethod;

    public static boolean isActive() {
        return active;
    }

    public static void setHook(Runnable hook) {
        Preconditions.checkNotNull((Object)hook);
        PreWorldRenderHookVisitor.hook = hook;
    }

    public static void callHook() {
        hook.run();
    }

    public PreWorldRenderHookVisitor(String rendererTypeCls, ClassVisitor cv, IResultListener listener) {
        super(327680, cv);
        this.listener = listener;
        Type injectedMethodType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.FLOAT_TYPE, Type.LONG_TYPE});
        this.modifiedMethod = new MethodMatcher(rendererTypeCls, injectedMethodType.getDescriptor(), "renderWorldPass", "func_175068_a");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.modifiedMethod.match(name, desc) ? new InjectorMethodVisitor(parent) : parent;
    }

    static {
        hook = () -> {};
    }

    private class InjectorMethodVisitor
    extends MethodVisitor {
        private final Type hookCls;
        private final Method hookMethod;
        private boolean isPrimed;

        public InjectorMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
            try {
                this.hookCls = Type.getType(PreWorldRenderHookVisitor.class);
                this.hookMethod = Method.getMethod((java.lang.reflect.Method)PreWorldRenderHookVisitor.class.getMethod("callHook", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            Log.debug("Injecting hook %s.%s into EntityRenderer.renderWorldPass", PreWorldRenderHookVisitor.class, this.hookMethod);
        }

        public void visitLdcInsn(Object cst) {
            if ("prepareterrain".equals(cst)) {
                this.isPrimed = true;
            }
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
            super.visitMethodInsn(opcode, owner, name, desc, intf);
            if (this.isPrimed) {
                this.isPrimed = false;
                this.visitMethodInsn(184, this.hookCls.getInternalName(), this.hookMethod.getName(), this.hookMethod.getDescriptor(), false);
                PreWorldRenderHookVisitor.this.listener.onSuccess();
                active = true;
            }
        }
    }
}

