/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import net.minecraft.util.math.AxisAlignedBB;

public class AabbBuilder {
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;

    public AabbBuilder(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public static AabbBuilder create() {
        return new AabbBuilder(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    }

    public AabbBuilder addPoint(float x, float y, float z) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        return this;
    }

    public AxisAlignedBB build() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }
}

