/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.templates.TemplateLibrary;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.io.FileUtils;

public class BookRegistry {
    public static final Set<ResourceLocation> REGISTRY = Sets.newHashSet();
    private static boolean booksLoaded = false;
    private static final Map<ResourceLocation, BookDocument> LOADED_BOOKS = Maps.newHashMap();
    private static boolean initialized = false;
    private static Type listType = new TypeToken<List<String>>(){}.getType();
    private static Field _defaultResourcePacks = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_110449_ao");

    public static Map<ResourceLocation, BookDocument> getLoadedBooks() {
        if (!booksLoaded) {
            BookRegistry.parseAllBooks(Minecraft.func_71410_x().func_110442_L());
        }
        return Collections.unmodifiableMap(LOADED_BOOKS);
    }

    public static void registerBook(ResourceLocation loc) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new IllegalStateException("Books must be registered before init, preferably in the BookRegistryEvent.");
        }
        REGISTRY.add(loc);
    }

    @Nullable
    public static BookDocument get(ResourceLocation loc) {
        return BookRegistry.getLoadedBooks().get(loc);
    }

    @Nullable
    public static BookDocument get(ItemStack stack) {
        String loc = GuidebookMod.guidebook.getBookLocation(stack);
        return loc == null ? null : BookRegistry.get(new ResourceLocation(loc));
    }

    public static void parseAllBooks(IResourceManager manager) {
        booksLoaded = true;
        TemplateLibrary.clear();
        LOADED_BOOKS.clear();
        HashSet toLoad = Sets.newHashSet(REGISTRY);
        for (String domain : manager.func_135055_a()) {
            try {
                List resources = manager.func_135056_b(new ResourceLocation(domain, "books.json"));
                for (IResource res : resources) {
                    BookRegistry.loadBooksData(toLoad, res);
                }
            }
            catch (FileNotFoundException resources) {
            }
            catch (IOException e) {
                GuidebookMod.logger.error("Error loading books from resourcepacks", (Throwable)e);
            }
        }
        BookRegistry.loadRawBookFiles();
        LanguageManager lm = Minecraft.func_71410_x().func_135016_M();
        String lang = (String)ObfuscationReflectionHelper.getPrivateValue(LanguageManager.class, (Object)lm, (String)"field_135048_c");
        if (lang == null) {
            lang = "en_us";
        }
        for (ResourceLocation loc : toLoad) {
            BookDocument book;
            if (LOADED_BOOKS.containsKey(loc) || (book = BookRegistry.parseBook(manager, loc, lang)) == null) continue;
            LOADED_BOOKS.put(loc, book);
        }
    }

    private static void loadBooksData(Set<ResourceLocation> toLoad, IResource resource) throws IOException {
        try (InputStream stream = resource.func_110527_b();){
            List yourList = (List)new Gson().fromJson((Reader)new InputStreamReader(stream), listType);
            toLoad.addAll(yourList.stream().map(ResourceLocation::new).collect(Collectors.toList()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static BookDocument parseBook(IResourceManager manager, ResourceLocation location, String lang) {
        BookDocument bookDocument = new BookDocument(location);
        try {
            IResource bookResource;
            String path;
            ResourceLocation bookLocation = bookDocument.getLocation();
            String domain = bookLocation.func_110624_b();
            String pathWithoutExtension = path = bookLocation.func_110623_a();
            String extension = "";
            int ext = path.lastIndexOf(46);
            if (ext >= 0) {
                pathWithoutExtension = path.substring(0, ext);
                extension = path.substring(ext);
            }
            String localizedPath = pathWithoutExtension + "." + lang + extension;
            ResourceLocation localizedLoc = new ResourceLocation(domain, localizedPath);
            try {
                bookResource = manager.func_110536_a(localizedLoc);
            }
            catch (IOException e) {
                bookResource = null;
            }
            if (bookResource == null) {
                bookResource = manager.func_110536_a(bookLocation);
            }
            try (InputStream stream = bookResource.func_110527_b();){
                if (bookDocument.parseBook(stream, false)) return bookDocument;
                BookDocument bookDocument2 = null;
                return bookDocument2;
            }
        }
        catch (IOException e) {
            bookDocument.initializeWithLoadError(e.toString());
        }
        return bookDocument;
    }

    @Nullable
    private static BookDocument parseBook(ResourceLocation location, File file) {
        BookDocument bookDocument = new BookDocument(location);
        try {
            FileInputStream stream = new FileInputStream(file);
            if (!bookDocument.parseBook(stream, true)) {
                return null;
            }
        }
        catch (IOException e) {
            bookDocument.initializeWithLoadError(e.toString());
        }
        return bookDocument;
    }

    private static void loadRawBookFiles() {
        File booksFolder = BookRegistry.getBooksFolder();
        if (booksFolder == null) {
            return;
        }
        Collection xmlFiles = FileUtils.listFiles((File)booksFolder, (String[])new String[]{"xml"}, (boolean)true);
        for (File f : xmlFiles) {
            BookDocument book;
            ResourceLocation loc;
            if (!f.isFile() || LOADED_BOOKS.containsKey(loc = new ResourceLocation("gbook", BookRegistry.relativePath(booksFolder, f))) || (book = BookRegistry.parseBook(loc, f)) == null) continue;
            LOADED_BOOKS.put(loc, book);
        }
    }

    @Nullable
    public static File getBooksFolder() {
        File booksFolder = new File(Loader.instance().getConfigDir(), "books");
        if (!booksFolder.exists()) {
            GuidebookMod.logger.info("The books folder does not exist, creating...");
            if (!booksFolder.mkdirs()) {
                GuidebookMod.logger.info("The books folder could not be created. Books can't be loaded from it.");
                return null;
            }
        }
        if (!booksFolder.exists() || !booksFolder.isDirectory()) {
            GuidebookMod.logger.info("There's a file called books, but it's not a directory. Books can't be loaded from it.");
            return null;
        }
        return booksFolder;
    }

    private static String relativePath(File base, File sub) {
        return base.toURI().relativize(sub.toURI()).getPath();
    }

    public static void injectCustomResourcePack() {
        if (initialized) {
            return;
        }
        initialized = true;
        File resourcesFolder = new File(new File(Loader.instance().getConfigDir(), "books"), "resources");
        if (!resourcesFolder.exists() && !resourcesFolder.mkdirs()) {
            return;
        }
        if (!resourcesFolder.exists() || !resourcesFolder.isDirectory()) {
            return;
        }
        try {
            List rp = (List)_defaultResourcePacks.get(Minecraft.func_71410_x());
            rp.add(new FolderResourcePack(resourcesFolder){
                String prefix = "assets/gbook/";

                protected InputStream func_110591_a(String name) throws IOException {
                    if ("pack.mcmeta".equals(name)) {
                        return new ByteArrayInputStream("{\"pack\":{\"description\": \"dummy\",\"pack_format\": 3}}".getBytes(Charsets.UTF_8));
                    }
                    if (!name.startsWith(this.prefix)) {
                        throw new FileNotFoundException(name);
                    }
                    return super.func_110591_a(name.substring(this.prefix.length()));
                }

                protected boolean func_110593_b(String name) {
                    if ("pack.mcmeta".equals(name)) {
                        return true;
                    }
                    if (!name.startsWith(this.prefix)) {
                        return false;
                    }
                    return super.func_110593_b(name.substring(this.prefix.length()));
                }

                public Set<String> func_110587_b() {
                    return Collections.singleton("gbook");
                }
            });
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static ResourceLocation[] gatherBookModels() {
        return (ResourceLocation[])LOADED_BOOKS.values().stream().map(BookDocument::getModel).filter(Objects::nonNull).distinct().toArray(ResourceLocation[]::new);
    }
}

