/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.integration.common.registry;

import org.icannt.netherendingores.common.registry.BlockData;
import org.icannt.netherendingores.integration.common.data.IC2RecipeData;
import org.icannt.netherendingores.integration.common.data.IERecipeData;
import org.icannt.netherendingores.integration.common.data.MekRecipeData;
import org.icannt.netherendingores.integration.common.data.TEIndSmeltRecipeData;
import org.icannt.netherendingores.integration.common.data.TERecipeData;
import org.icannt.netherendingores.integration.common.data.TiCRecipeData;

public class RecipeIntegrationHelper {
    public static void addIntegrationRecipe(BlockData blockData, String device, String material) {
        switch (device) {
            case "smeltery": {
                TiCRecipeData.addSmeltRecipe(blockData);
                break;
            }
            case "crusher": {
                IERecipeData.addCrusherRecipe(blockData, material);
                break;
            }
            case "arcfurn": {
                IERecipeData.addArcFurnRecipe(blockData, material);
                break;
            }
            case "pulv": {
                TERecipeData.addPulvRecipe(blockData, material);
                break;
            }
            case "redfurn": {
                TERecipeData.addRedFurnRecipe(blockData, material);
                break;
            }
            case "indsmeltsand": {
                TEIndSmeltRecipeData.addIndSmeltSandRecipe(blockData, material);
                break;
            }
            case "indsmeltrichslag": {
                TEIndSmeltRecipeData.addIndSmeltRichSlagRecipe(blockData, material);
                break;
            }
            case "enrich": {
                MekRecipeData.addEnrichRecipe(blockData, material);
                break;
            }
            case "mace": {
                IC2RecipeData.addMaceRecipe(blockData, material);
            }
        }
    }
}

