/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.icannt.netherendingores.common.registry.BlockData;
import org.icannt.netherendingores.common.registry.OreDictionaryOtherData;
import org.icannt.netherendingores.lib.Config;
import org.icannt.netherendingores.lib.Log;

@GameRegistry.ObjectHolder(value="netherendingores")
public class OreDictionaryRegistry {
    public static void registerDictionaryOres() {
        Log.debug("Registering Ore Dictionary Entries");
        for (OreDictionaryOtherData oreDictionaryOtherData : OreDictionaryOtherData.values()) {
            if (!oreDictionaryOtherData.getEnabled() || !Loader.isModLoaded((String)oreDictionaryOtherData.getModCodeName()) || OreDictionary.doesOreNameExist((String)oreDictionaryOtherData.func_176610_l())) continue;
            ItemStack stack = new ItemStack(Item.func_111206_d((String)(oreDictionaryOtherData.getModCodeName() + ":" + oreDictionaryOtherData.getModItemCodeName())), 1, oreDictionaryOtherData.getMeta());
            if (!stack.func_190926_b()) {
                OreDictionary.registerOre((String)oreDictionaryOtherData.func_176610_l(), (ItemStack)stack);
                Log.logOreDictSuccess(oreDictionaryOtherData.func_176610_l(), Log.itemStackToName(stack));
                continue;
            }
            Log.logOreDictFail(oreDictionaryOtherData.func_176610_l(), Log.itemStackToName(stack));
        }
        for (Enum enum_ : BlockData.values()) {
            OreDictionary.registerOre((String)((BlockData)enum_).getOreDictRegName(), (ItemStack)((BlockData)enum_).getModBlockItemStack());
            Log.logOreDictSuccess(((BlockData)enum_).getOreDictRegName(), ((BlockData)enum_).getBlockLogInfo());
            for (String material : ((BlockData)enum_).getItemAltOreDictSuffix()) {
                OreDictionary.registerOre((String)((BlockData)enum_).getOreDictCustomRegName(material), (ItemStack)((BlockData)enum_).getModBlockItemStack());
                Log.logOreDictSuccess(((BlockData)enum_).getOreDictCustomRegName(material), ((BlockData)enum_).getBlockLogInfo());
            }
        }
        Log.info("Registered Ore Dictionary Entries");
    }

    public static void cacheOreDictionaryItems() {
        for (BlockData blockData : BlockData.values()) {
            if (blockData.getRecipeMultiplier() <= 0 || !blockData.getDropItems() || !Config.dropItems) continue;
            blockData.setDropItemObject();
        }
    }
}

