/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluid;

import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.material.Material;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.SoundEvent;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.IProperties;
import thelm.jaopca.api.block.BlockFluidBase;
import thelm.jaopca.api.block.IBlockFluidWithProperty;
import thelm.jaopca.api.fluid.FluidBase;
import thelm.jaopca.api.fluid.IFluidWithProperty;
import thelm.jaopca.api.item.IItemBlockFluidWithProperty;
import thelm.jaopca.api.item.ItemBlockFluidBase;

public class FluidProperties
implements IProperties {
    public static final FluidProperties DEFAULT = new FluidProperties();
    public ToIntFunction<IOreEntry> luminosFunc = entry -> 0;
    public ToIntFunction<IOreEntry> densityFunc = entry -> 1000;
    public ToIntFunction<IOreEntry> tempFunc = entry -> 300;
    public ToIntFunction<IOreEntry> viscosFunc = entry -> 1000;
    public Predicate<IOreEntry> gaseous = entry -> this.densityFunc.applyAsInt((IOreEntry)entry) < 0;
    public EnumRarity rarity = EnumRarity.COMMON;
    public SoundEvent fillSound = SoundEvents.field_187630_M;
    public SoundEvent emptySound = SoundEvents.field_187624_K;
    public ToIntFunction<IOreEntry> opacityFunc = entry -> 255;
    public boolean hasBlock = true;
    public Material material = Material.field_151586_h;
    public ToIntFunction<IOreEntry> quantaFunc = entry -> 8;
    public Class<? extends IFluidWithProperty> fluidClass = FluidBase.class;
    public Class<? extends IBlockFluidWithProperty> blockFluidClass = BlockFluidBase.class;
    public Class<? extends IItemBlockFluidWithProperty> itemBlockFluidClass = ItemBlockFluidBase.class;

    @Override
    public EnumEntryType getType() {
        return EnumEntryType.FLUID;
    }

    public FluidProperties setLuminosityFunc(ToIntFunction<IOreEntry> value) {
        this.luminosFunc = value;
        return this;
    }

    public FluidProperties setDensityFunc(ToIntFunction<IOreEntry> value) {
        this.densityFunc = value;
        return this;
    }

    public FluidProperties setTemperatureFunc(ToIntFunction<IOreEntry> value) {
        this.tempFunc = value;
        return this;
    }

    public FluidProperties setViscosityFunc(ToIntFunction<IOreEntry> value) {
        this.viscosFunc = value;
        return this;
    }

    public FluidProperties setGaseousPredicate(Predicate<IOreEntry> value) {
        this.gaseous = value;
        return this;
    }

    public FluidProperties setRarity(EnumRarity value) {
        this.rarity = value;
        return this;
    }

    public FluidProperties setFillSound(SoundEvent value) {
        this.fillSound = value;
        return this;
    }

    public FluidProperties setEmptySound(SoundEvent value) {
        this.emptySound = value;
        return this;
    }

    public FluidProperties setOpacityFunc(ToIntFunction<IOreEntry> value) {
        this.opacityFunc = value;
        return this;
    }

    public FluidProperties setHasBlock(boolean value) {
        this.hasBlock = value;
        return this;
    }

    public FluidProperties setMaterial(Material value) {
        this.material = value;
        return this;
    }

    public FluidProperties setQuantaFunc(ToIntFunction<IOreEntry> value) {
        this.quantaFunc = value;
        return this;
    }

    public FluidProperties setFluidClass(Class<? extends IFluidWithProperty> value) {
        this.fluidClass = value;
        return this;
    }

    public FluidProperties setBlockFluidClass(Class<? extends IBlockFluidWithProperty> value) {
        this.blockFluidClass = value;
        return this;
    }

    public FluidProperties setItemBlockFluidClass(Class<? extends IItemBlockFluidWithProperty> value) {
        this.itemBlockFluidClass = value;
        return this;
    }
}

