/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.init.ModItems;
import xreliquary.init.ModSounds;
import xreliquary.items.ItemBase;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.potions.XRPotionHelper;

public class ItemHandgun
extends ItemBase {
    private static final int PLAYER_HANDGUN_SKILL_MAXIMUM = 20;
    private static final int HANDGUN_RELOAD_SKILL_OFFSET = 10;
    private static final int HANDGUN_COOLDOWN_SKILL_OFFSET = 5;

    public ItemHandgun() {
        super("handgun");
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    public short getBulletCount(ItemStack handgun) {
        return NBTHelper.getShort("bulletCount", handgun);
    }

    private void setBulletCount(ItemStack handgun, short bulletCount) {
        NBTHelper.setShort("bulletCount", handgun, bulletCount);
    }

    public short getBulletType(ItemStack handgun) {
        return NBTHelper.getShort("bulletType", handgun);
    }

    private void setBulletType(ItemStack handgun, short bulletType) {
        NBTHelper.setShort("bulletType", handgun, bulletType);
    }

    private boolean isInCooldown(ItemStack handgun) {
        return NBTHelper.getBoolean("inCoolDown", handgun);
    }

    private void setInCooldown(ItemStack handgun, boolean inCooldown) {
        NBTHelper.setBoolean("inCoolDown", handgun, inCooldown);
    }

    public long getCooldown(ItemStack handgun) {
        return NBTHelper.getLong("coolDownTime", handgun);
    }

    private void setCooldown(ItemStack handgun, long coolDownTime) {
        NBTHelper.setLong("coolDownTime", handgun, coolDownTime);
    }

    public List<PotionEffect> getPotionEffects(ItemStack handgun) {
        return XRPotionHelper.getPotionEffectsFromStack(handgun);
    }

    private void setPotionEffects(ItemStack handgun, List<PotionEffect> potionEffects) {
        XRPotionHelper.cleanPotionEffects(handgun);
        XRPotionHelper.addPotionEffectsToStack(handgun, potionEffects);
    }

    @Override
    protected void addMoreInformation(ItemStack handgun, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(handgun) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(this.getBulletCount(handgun)), (Object)"type", (Object)LanguageHelper.getLocalization("item.bullet_" + this.getBulletType(handgun) + ".name", new Object[0])), tooltip);
        XRPotionHelper.addPotionTooltip(handgun, tooltip);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack handgun) {
        if (this.getBulletCount(handgun) > 0) {
            return EnumAction.NONE;
        }
        return EnumAction.BLOCK;
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void func_77663_a(ItemStack handgun, World world, Entity entity, int slotNumber, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isInCooldown(handgun) && (this.isCooldownOver(world, handgun) || !this.isValidCooldownTime(world, handgun))) {
            this.setInCooldown(handgun, false);
        }
    }

    private boolean isCooldownOver(World world, ItemStack handgun) {
        return this.getCooldown(handgun) < world.func_82737_E() && world.func_82737_E() - this.getCooldown(handgun) < 12000L;
    }

    private boolean isValidCooldownTime(World world, ItemStack handgun) {
        return Math.min(Math.abs(world.func_82737_E() - this.getCooldown(handgun)), Math.abs(world.func_82737_E() - 23999L - this.getCooldown(handgun))) <= (long)this.func_77626_a(handgun);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack handgun = player.func_184586_b(hand);
        if (this.hasFilledMagazine(player) && this.getBulletCount(handgun) == 0 || this.getBulletCount(handgun) > 0 && (!this.hasHandgunInSecondHand(player, hand) || this.cooledMoreThanSecondHandgun(handgun, player, hand))) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)handgun);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)handgun);
    }

    private boolean cooledMoreThanSecondHandgun(ItemStack handgun, EntityPlayer player, EnumHand hand) {
        if (!this.isInCooldown(handgun)) {
            return true;
        }
        if (hand == EnumHand.MAIN_HAND) {
            return !this.isInCooldown(player.func_184592_cb()) && this.getCooldown(handgun) < this.getCooldown(player.func_184592_cb());
        }
        return !this.isInCooldown(player.func_184614_ca()) && this.getCooldown(handgun) < this.getCooldown(player.func_184614_ca());
    }

    private boolean secondHandgunCooledEnough(World world, EntityPlayer player, EnumHand hand) {
        ItemStack secondHandgun = hand == EnumHand.MAIN_HAND ? player.func_184592_cb() : player.func_184614_ca();
        return !this.isInCooldown(secondHandgun) || this.getCooldown(secondHandgun) - world.func_82737_E() < (long)(this.getPlayerReloadDelay(player) / 2);
    }

    private boolean hasHandgunInSecondHand(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return player.func_184592_cb().func_77973_b() == this;
        }
        return player.func_184614_ca().func_77973_b() == this;
    }

    public void onUsingTick(ItemStack handgun, EntityLivingBase entity, int unadjustedCount) {
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int maxUseOffset = this.getItemUseDuration() - this.getPlayerReloadDelay(player);
        int actualCount = unadjustedCount - maxUseOffset;
        if (!this.hasFilledMagazine(player) || --actualCount == 0) {
            player.func_184597_cx();
            return;
        }
        if (!(this.isInCooldown(handgun) || this.getBulletCount(handgun) <= 0 || this.hasHandgunInSecondHand(player, player.func_184600_cs()) && !this.secondHandgunCooledEnough(player.field_70170_p, player, player.func_184600_cs()))) {
            player.func_184597_cx();
        }
    }

    public int func_77626_a(ItemStack handgun) {
        return this.getItemUseDuration();
    }

    public void func_77615_a(ItemStack handgun, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (this.getBulletCount(handgun) > 0) {
            if (!this.isInCooldown(handgun)) {
                this.setCooldown(handgun, worldIn.func_82737_E() + 20L + 5L - (long)Math.min(player.field_71068_ca, 20));
                this.setInCooldown(handgun, true);
                this.fireBullet(handgun, worldIn, player, handgun == player.func_184614_ca() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            }
            return;
        }
        this.setCooldown(handgun, player.field_70170_p.func_82737_E() + 12L);
        this.setInCooldown(handgun, true);
        int slot = this.getMagazineSlot(player);
        if (slot != -1) {
            ItemStack magazine = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            this.setBulletType(handgun, (short)magazine.func_77960_j());
            this.setPotionEffects(handgun, XRPotionHelper.getPotionEffectsFromStack(magazine));
            magazine.func_190918_g(1);
            if (magazine.func_190926_b()) {
                player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
        if (this.getBulletType(handgun) != 0) {
            player.func_184609_a(player.func_184600_cs());
            this.spawnEmptyMagazine(player);
            this.setBulletCount(handgun, (short)8);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.xload, SoundCategory.PLAYERS, 0.25f, 1.0f);
        }
        if (this.getBulletCount(handgun) == 0) {
            this.setBulletType(handgun, (short)0);
            this.setPotionEffects(handgun, null);
        }
    }

    private int getItemUseDuration() {
        return 30;
    }

    private void fireBullet(ItemStack handgun, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            switch (this.getBulletType(handgun)) {
                case 1: {
                    world.func_72838_d((Entity)new EntityNeutralShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 2: {
                    world.func_72838_d((Entity)new EntityExorcismShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 3: {
                    world.func_72838_d((Entity)new EntityBlazeShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 4: {
                    world.func_72838_d((Entity)new EntityEnderShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 5: {
                    world.func_72838_d((Entity)new EntityConcussiveShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 6: {
                    world.func_72838_d((Entity)new EntityBusterShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 7: {
                    world.func_72838_d((Entity)new EntitySeekerShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 8: {
                    world.func_72838_d((Entity)new EntitySandShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 9: {
                    world.func_72838_d((Entity)new EntityStormShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                default: {
                    return;
                }
            }
            world.func_184133_a(null, player.func_180425_c(), ModSounds.xshot, SoundCategory.PLAYERS, 0.5f, 1.2f);
            this.setBulletCount(handgun, (short)(this.getBulletCount(handgun) - 1));
            if (this.getBulletCount(handgun) == 0) {
                this.setBulletType(handgun, (short)0);
                this.setPotionEffects(handgun, null);
            }
            this.spawnCasing(player);
        }
    }

    private void spawnEmptyMagazine(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.magazine, 1, 0))) {
            player.func_70099_a(new ItemStack((Item)ModItems.magazine, 1, 0), 0.1f);
        }
    }

    private void spawnCasing(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.bullet, 1, 0))) {
            player.func_70099_a(new ItemStack((Item)ModItems.bullet, 1, 0), 0.1f);
        }
    }

    private boolean hasFilledMagazine(EntityPlayer player) {
        for (ItemStack ist : player.field_71071_by.field_70462_a) {
            if (ist == null || ist.func_77973_b() != ModItems.magazine || ist.func_77952_i() == 0) continue;
            return true;
        }
        return false;
    }

    private int getMagazineSlot(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() != ModItems.magazine || ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77952_i() == 0) continue;
            return slot;
        }
        return -1;
    }

    public boolean func_77662_d() {
        return true;
    }

    private int getPlayerReloadDelay(EntityPlayer player) {
        return 30 - Math.min(player.field_71068_ca, 20);
    }
}

