/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.factories;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.crafting.AlkahestryTomeIngredient;
import xreliquary.init.ModItems;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemAlkahestryTome;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AlkahestryChargingRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for alkahestry crafting recipe");
        }
        if (ingredients.size() > 1) {
            throw new JsonParseException("Too many ingredients for alkahestry crafting recipe");
        }
        int chargeToAdd = JsonUtils.func_151203_m((JsonObject)json, (String)"charge");
        ItemStack tome = new ItemStack((Item)ModItems.alkahestryTome);
        ItemAlkahestryTome.setCharge(tome, 0);
        return new AlkahestryChargingRecipe(new ResourceLocation("xreliquary", "alkahestry_charging"), (Ingredient)ingredients.get(0), new AlkahestryTomeIngredient(tome, 0), chargeToAdd);
    }

    public class AlkahestryChargingRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private final ResourceLocation group;
        private final Ingredient chargingIngredient;
        private final Ingredient tomeIngredient;
        private final Predicate<ItemStack> tomeIngredientMatch;
        private final int chargeToAdd;
        private final ItemStack result;

        public int getChargeToAdd() {
            return this.chargeToAdd;
        }

        public AlkahestryChargingRecipe(ResourceLocation group, Ingredient chargingIngredient, Ingredient tomeIngredient, int chargeToAdd) {
            this.group = group;
            this.chargingIngredient = chargingIngredient;
            this.tomeIngredientMatch = s -> tomeIngredient.apply(s) && ItemAlkahestryTome.getCharge(s) + chargeToAdd <= ItemAlkahestryTome.getChargeLimit();
            this.tomeIngredient = tomeIngredient;
            this.chargeToAdd = chargeToAdd;
            this.result = new ItemStack((Item)ModItems.alkahestryTome);
            ItemAlkahestryTome.addCharge(this.result, chargeToAdd);
            XRRecipes.chargingRecipes.add(this);
        }

        public boolean func_77569_a(InventoryCrafting inv, World world) {
            boolean hasTome = false;
            boolean hasIngredient = false;
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack slot = inv.func_70301_a(x);
                if (slot.func_190926_b()) continue;
                boolean inRecipe = false;
                if (this.chargingIngredient.apply(slot)) {
                    inRecipe = true;
                    hasIngredient = true;
                } else if (!hasTome && this.tomeIngredientMatch.test(slot)) {
                    inRecipe = true;
                    hasTome = true;
                }
                if (inRecipe) continue;
                return false;
            }
            return hasIngredient && hasTome;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            int numberOfIngredients = 0;
            ItemStack tome = ItemStack.field_190927_a;
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (this.chargingIngredient.apply(stack)) {
                    ++numberOfIngredients;
                    continue;
                }
                if (!this.tomeIngredientMatch.test(stack)) continue;
                tome = stack.func_77946_l();
            }
            ItemAlkahestryTome.addCharge(tome, this.chargeToAdd * numberOfIngredients);
            return tome;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 2;
        }

        public ItemStack func_77571_b() {
            return this.result;
        }

        public String func_193358_e() {
            return this.group.toString();
        }

        public NonNullList<Ingredient> func_192400_c() {
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.chargingIngredient, this.tomeIngredient});
        }

        public Ingredient getChargingIngredient() {
            return this.chargingIngredient;
        }
    }
}

