/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.tile;

import icbm.classic.api.energy.IEnergyBuffer;
import icbm.classic.api.energy.IEnergyBufferProvider;
import icbm.classic.config.ConfigMain;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TilePoweredMachine
extends TileMachine
implements IEnergyBufferProvider {
    EnergyBuffer buffer;

    public int getEnergy() {
        return 10000;
    }

    public void setEnergy(int energy) {
        IEnergyBuffer buffer;
        if (this.needsPower() && (buffer = this.getEnergyBuffer(null)) != null) {
            buffer.setEnergyStored(energy);
        }
    }

    public void extractEnergy() {
        IEnergyBuffer buffer;
        if (this.needsPower() && (buffer = this.getEnergyBuffer(null)) != null) {
            buffer.removeEnergyFromStorage(this.getEnergyConsumption(), true);
        }
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeInt(this.getEnergy());
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.setEnergy(buf.readInt());
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setEnergy(compound.func_74762_e("energy"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.getEnergy());
        return super.func_189515_b(compound);
    }

    public boolean checkExtract() {
        return !this.needsPower() || this.getEnergy() >= this.getEnergyConsumption();
    }

    public int getEnergyConsumption() {
        return 10000;
    }

    public int getEnergyBufferSize() {
        return this.getEnergyConsumption() * 2;
    }

    public boolean hasPower() {
        return !this.needsPower() || this.getEnergy() > 0;
    }

    public boolean needsPower() {
        return ConfigMain.REQUIRES_POWER;
    }

    @Override
    public IEnergyBuffer getEnergyBuffer(EnumFacing side) {
        if (this.buffer == null) {
            this.buffer = new PowerBuffer(this);
        }
        return this.buffer;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.needsPower()) {
            return (T)this.getEnergyBuffer(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.needsPower();
        }
        return super.hasCapability(capability, facing);
    }

    public static class PowerBuffer
    extends EnergyBuffer {
        TilePoweredMachine machine;

        public PowerBuffer(TilePoweredMachine machine) {
            super(machine.getEnergyBufferSize());
            this.machine = machine;
        }

        @Override
        public int getMaxBufferSize() {
            return this.machine.getEnergyBufferSize();
        }
    }
}

