/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blast.Blast;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class ExplosiveHandler {
    public static final ArrayList<Blast> activeBlasts = new ArrayList();

    public static void add(Blast blast) {
        activeBlasts.add(blast);
    }

    public static void remove(Blast blast) {
        activeBlasts.remove(blast);
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            Iterator<Blast> it = activeBlasts.iterator();
            while (it.hasNext()) {
                Blast next = it.next();
                if (next.field_77287_j != null && next.field_77287_j.field_73011_w.getDimension() != event.getWorld().field_73011_w.getDimension()) continue;
                ExplosiveHandler.onKill(next);
                it.remove();
            }
        }
    }

    public static void onKill(Blast blast) {
        if (blast.getThread() != null) {
            blast.getThread().kill();
        }
        blast.isAlive = false;
    }

    public static int removeNear(World world, double x, double y, double z, double range) {
        int removeCount = 0;
        Iterator<Blast> it = activeBlasts.iterator();
        while (it.hasNext()) {
            Blast blast = it.next();
            if (blast.field_77287_j != world || !(range < 0.0) && (!(range > 0.0) || !(range > blast.location.distance(x, y, z)))) continue;
            ExplosiveHandler.onKill(blast);
            it.remove();
            ++removeCount;
        }
        return removeCount;
    }

    public static BlastState createExplosion(Entity cause, World world, double x, double y, double z, IExplosive capabilityExplosive) {
        if (capabilityExplosive == null || capabilityExplosive.getExplosiveData() == null) {
            ICBMClassic.logger().error("ExplosiveHandler: Missing capability for explosive, cap: " + capabilityExplosive + "  cause: " + cause, (Throwable)new RuntimeException());
            return BlastState.NULL;
        }
        return ExplosiveHandler.createExplosion(cause, world, x, y, z, capabilityExplosive.getExplosiveData().getRegistryID(), 1.0f, capabilityExplosive.getCustomBlastData());
    }

    public static BlastState createExplosion(Entity cause, World world, double x, double y, double z, int blastID, float scale, NBTTagCompound customData) {
        IBlast blast = ExplosiveHandler.createNew(cause, world, x, y, z, blastID, scale, customData);
        if (blast != null) {
            return blast.runBlast();
        }
        return BlastState.NULL;
    }

    public static IBlast createNew(Entity cause, World world, double x, double y, double z, int blastID, float scale, NBTTagCompound customData) {
        IExplosiveData explosiveData = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(blastID);
        return ExplosiveHandler.createNew(cause, world, x, y, z, explosiveData, scale, customData);
    }

    public static IBlast createNew(Entity cause, World world, double x, double y, double z, IExplosiveData data, float scale, NBTTagCompound customData) {
        if (data != null && data.getBlastFactory() != null) {
            IBlastInit blast = data.getBlastFactory().createNewBlast();
            blast.setBlastWorld(world);
            blast.setBlastPosition(x, y, z);
            blast.scaleBlast(scale);
            blast.setBlastSource(cause);
            blast.setExplosiveData(data);
            return blast.buildBlast();
        }
        ICBMClassic.logger().error("ExplosiveHandler: Failed to create blast, data: " + data + " factory: " + (data != null ? data.getBlastFactory() : " nil"), (Throwable)new RuntimeException());
        return null;
    }
}

