/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.api.ExplosiveRefs;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.tile.IRotatable;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.capability.emp.CapabilityEmpKill;
import icbm.classic.lib.capability.ex.CapabilityExplosiveEntity;
import icbm.classic.lib.explosive.ExplosiveHandler;
import icbm.classic.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityExplosive
extends Entity
implements IRotatable,
IEntityAdditionalSpawnData {
    public int fuse = -1;
    private EnumFacing _facing = EnumFacing.NORTH;
    public final IEMPReceiver capabilityEMP = new CapabilityEmpKill<EntityExplosive>(this);
    public final CapabilityExplosiveEntity capabilityExplosive = new CapabilityExplosiveEntity(this);

    public EntityExplosive(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityExplosive(World par1World, Pos position, EnumFacing orientation, ItemStack stack) {
        this(par1World);
        this.func_70107_b(position.x(), position.y(), position.z());
        float var8 = (float)(Math.random() * Math.PI * 2.0);
        this.field_70159_w = -((float)Math.sin(var8)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(var8)) * 0.02f;
        this.field_70169_q = position.x();
        this.field_70167_r = position.y();
        this.field_70166_s = position.z();
        this._facing = orientation;
        this.capabilityExplosive.setStack(stack);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w *= 0.95;
        this.field_70181_x -= 0.045;
        this.field_70179_y *= 0.95;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        if (this.fuse == -1) {
            this.fuse = ICBMClassicAPI.EX_BLOCK_REGISTRY.getFuseTime(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getExplosiveData().getRegistryID());
        }
        ICBMClassicAPI.EX_BLOCK_REGISTRY.tickFuse(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.fuse, this.getExplosiveData().getRegistryID());
        if (this.fuse-- < 1) {
            this.explode();
        }
        super.func_70071_h_();
    }

    public void explode() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        ExplosiveHandler.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getExplosiveCap());
        this.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.fuse = nbt.func_74771_c("Fuse");
        this.getExplosiveCap().deserializeNBT(nbt.func_74775_l("explosive_stack"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Fuse", (byte)this.fuse);
        nbt.func_74782_a("explosive_stack", (NBTBase)this.getExplosiveCap().serializeNBT());
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    @Override
    public EnumFacing getDirection() {
        if (this._facing == null) {
            this._facing = EnumFacing.NORTH;
        }
        return this._facing;
    }

    @Override
    public void setDirection(EnumFacing facingDirection) {
        this._facing = facingDirection;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.fuse);
        data.writeByte(this.getDirection().ordinal());
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.getExplosiveCap().serializeNBT());
    }

    public void readSpawnData(ByteBuf data) {
        this.fuse = data.readInt();
        this._facing = EnumFacing.func_82600_a((int)data.readByte());
        this.getExplosiveCap().deserializeNBT(ByteBufUtils.readTag((ByteBuf)data));
    }

    public CapabilityExplosiveEntity getExplosiveCap() {
        return this.capabilityExplosive;
    }

    public IExplosiveData getExplosiveData() {
        IExplosiveData data;
        if (this.getExplosiveCap() != null && (data = this.getExplosiveCap().getExplosiveData()) != null) {
            return data;
        }
        return ExplosiveRefs.CONDENSED;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEMP.EMP) {
            return (T)this.capabilityEMP;
        }
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)this.getExplosiveCap();
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEMP.EMP) {
            return true;
        }
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public String func_70005_c_() {
        if (this.getExplosiveData() != null) {
            return "Explosive[" + this.getExplosiveData().getRegistryName() + "]";
        }
        return "Explosive";
    }
}

