/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.explosive;

import icbm.classic.api.EnumTier;
import icbm.classic.api.ExplosiveRefs;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.capability.ex.CapabilityExplosiveStack;
import icbm.classic.prefab.item.ItemBlockAbstract;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockExplosive
extends ItemBlockAbstract {
    private final String count_key = "icbm.explosive.redMatter.info.count";
    private int tauntCount = 0;
    private int redmatterRandomTranslations = -1;
    private Long lastTranslationChange = 0L;
    private static int changeOverDelay = 60000;

    public ItemBlockExplosive(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityExplosiveStack capabilityExplosive = new CapabilityExplosiveStack(stack);
        if (nbt != null) {
            capabilityExplosive.deserializeNBT(nbt);
        }
        return capabilityExplosive;
    }

    @Override
    public void getDetailedInfo(ItemStack stack, @Nullable EntityPlayer player, List list) {
        IExplosiveData data = ICBMClassicHelpers.getExplosive(stack.func_77952_i(), true);
        if (data != null) {
            EnumTier tierdata = data.getTier();
            list.add(TextFormatting.DARK_RED + LanguageUtility.getLocal("info.misc.tier") + ": " + tierdata.getTooltipColor() + tierdata.getLocalizedName());
        }
        if (stack.func_77952_i() == ExplosiveRefs.REDMATTER.getRegistryID()) {
            boolean taunt = this.shouldTauntPlayer(player);
            if (taunt) {
                switch (this.tauntCount) {
                    case 0: {
                        list.add("Place me, you know you want to :)");
                    }
                    case 1: {
                        list.add("Mine with me, lets get some minerals!!");
                    }
                    case 2: {
                        list.add("Can you hear the noises in the dark?");
                    }
                    case 3: {
                        list.add("One does not simply use");
                        list.add("redmatter to cancel redmatter");
                    }
                    case 4: {
                        list.add("Nice base you have");
                        list.add("be a shame if something");
                        list.add("would happen to it");
                    }
                    case 5: {
                        list.add("Don't worry i've changed");
                    }
                    case 6: {
                        list.add("Lets eat a world together");
                    }
                    case 7: {
                        list.add("I'm back for you");
                    }
                }
            } else {
                this.normalDetailedInfo(list);
            }
            if (player != null && System.currentTimeMillis() - this.lastTranslationChange > (long)changeOverDelay) {
                this.lastTranslationChange = System.currentTimeMillis();
                if (taunt) {
                    this.tauntCount = player.field_70170_p.field_73012_v.nextInt(7);
                } else if (this.redmatterRandomTranslations > 0) {
                    this.tauntCount = player.field_70170_p.field_73012_v.nextInt(this.redmatterRandomTranslations);
                }
            }
        } else {
            super.getDetailedInfo(stack, player, list);
        }
    }

    protected boolean shouldTauntPlayer(@Nullable EntityPlayer player) {
        return player != null && player.func_70005_c_() != null && (player.func_70005_c_().toLowerCase().startsWith("sips_") || player.func_70005_c_().toLowerCase().startsWith("sjin"));
    }

    protected void normalDetailedInfo(List list) {
        String translationKey;
        String translation;
        if (this.redmatterRandomTranslations == -1) {
            try {
                this.redmatterRandomTranslations = Integer.parseInt(LanguageUtility.getLocal("icbm.explosive.redMatter.info.count"));
            }
            catch (NumberFormatException e) {
                this.redmatterRandomTranslations = 0;
            }
        }
        if (!(translation = LanguageUtility.getLocal(translationKey = "icbm.explosive.redMatter.info." + this.tauntCount)).isEmpty() && !translation.equals(translationKey)) {
            list.addAll(LanguageUtility.splitByLine(translation));
        }
    }

    @Override
    protected boolean hasDetailedInfo(ItemStack stack, EntityPlayer player) {
        return true;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemstack) {
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(itemstack.func_77952_i());
        if (data != null) {
            return "explosive." + data.getRegistryName();
        }
        return "explosive";
    }

    public String func_77658_a() {
        return "explosive";
    }
}

