/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.threaded;

import icbm.classic.api.events.BlastCancelEvent;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigBlast;
import icbm.classic.content.blast.BlastHelpers;
import icbm.classic.content.blast.BlastRedmatter;
import icbm.classic.content.blast.threaded.BlastThreaded;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.lib.transform.BlockEditHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlastAntimatter
extends BlastThreaded {
    private final IBlockState replaceState = Blocks.field_150350_a.func_176223_P();

    @Override
    public void setupBlast() {
        super.setupBlast();
        ICBMSounds.ANTIMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 7.0f, (float)((double)this.world().field_73012_v.nextFloat() * 0.1 + (double)0.9f), true);
        this.doDamageEntities(this.getBlastRadius() * 2.0f, 2.1474836E9f);
    }

    @Override
    public void destroyBlock(BlockPos blockPos) {
        if (!this.field_77287_j.func_175667_e(blockPos)) {
            return;
        }
        IBlockState blockState = this.field_77287_j.func_180495_p(blockPos);
        if (!blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_77287_j, blockPos) && (blockState.func_185887_b(this.field_77287_j, blockPos) >= 0.0f || ConfigBlast.ANTIMATTER_DESTROY_UNBREAKABLE_BLOCKS)) {
            this.field_77287_j.func_180501_a(blockPos, this.replaceState, ConfigBlast.BLAST_DO_BLOCKUPDATES ? 3 : 2);
        }
    }

    @Override
    public boolean doRun(int loops, Consumer<BlockPos> edits) {
        BlastHelpers.loopInRadius(this.getBlastRadius(), (x, y, z) -> {
            if (this.isInsideMap(y + this.yi()) && this.shouldEditPos(x, y, z)) {
                edits.accept(new BlockPos(this.xi() + x, this.yi() + y, this.zi() + z));
            }
        });
        return false;
    }

    @Override
    protected void onWorkerThreadComplete(List<BlockPos> edits) {
        if (this.field_77287_j instanceof WorldServer) {
            edits.sort(this.buildSorter());
            List removeFirst = edits.stream().filter(blockPos -> {
                if (this.field_77287_j.func_175667_e(blockPos)) {
                    IBlockState state = this.field_77287_j.func_180495_p(blockPos);
                    return state.func_185904_a() == Material.field_151586_h || state.func_177230_c() instanceof BlockFalling;
                }
                return true;
            }).collect(Collectors.toList());
            ((WorldServer)this.field_77287_j).func_152344_a(() -> {
                removeFirst.forEach(blockPos -> this.field_77287_j.func_180501_a(blockPos, this.replaceState, 2));
                BlockEditHandler.queue(this.field_77287_j, edits, this::destroyBlock);
                this.onPostThreadJoinWorld();
            });
        }
    }

    protected boolean isInsideMap(int y) {
        return y >= 0 && y < 256;
    }

    protected boolean shouldEditPos(int x, int y, int z) {
        double distSQ = x * x + y * y + z * z;
        double blastSQ = this.getBlastRadius() * this.getBlastRadius();
        int featherEdge = (int)Math.floor(blastSQ * (double)0.05f);
        int delta = (int)Math.floor(blastSQ - distSQ);
        if (delta < featherEdge) {
            double p2 = 1.0 - (double)delta / (double)featherEdge;
            return (double)this.world().field_73012_v.nextFloat() < p2;
        }
        return true;
    }

    @Override
    public void onBlastCompleted() {
        super.onBlastCompleted();
        this.doDamageEntities(this.getBlastRadius() * 2.0f, 2.1474836E9f);
    }

    @Override
    protected boolean onDamageEntity(Entity entity) {
        if (entity instanceof EntityExplosion && ((EntityExplosion)entity).getBlast() instanceof BlastRedmatter) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new BlastCancelEvent(this, ((EntityExplosion)entity).getBlast()))) {
                entity.func_70106_y();
            }
            return true;
        }
        return !ConfigBlast.ANTIMATTER_BLOCK_AND_ENT_DAMAGE_ON_REDMATTER;
    }
}

