/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.m_guide.json.objects;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.core.io.json.IJsonSerializer;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.VLEleContBase;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.image.VLElementImageScaled;
import com.valkyrieofnight.vliblegacy.lib.client.util.TextureLoc;
import com.valkyrieofnight.vliblegacy.m_guide.json.objects.GuideObject;
import java.lang.reflect.Type;
import net.minecraft.util.ResourceLocation;

public class GOImage
extends GuideObject {
    public static final GOImage BLANK = new GOImage();
    public int xSize;
    public int ySize;
    public String location;
    public int xStart;
    public int yStart;
    public int xEnd;
    public int yEnd;

    @Override
    public String getType() {
        return "image";
    }

    public String toString() {
        String str = "{" + this.xSize + ":" + this.ySize + ":" + this.location + "}";
        return str;
    }

    @Override
    public void initElement(String baseAddress, VLEleContBase cont) {
        TextureLoc tex = new TextureLoc(new ResourceLocation(this.location), this.xStart, this.yStart, this.xEnd, this.yEnd);
        VLElementImageScaled e = new VLElementImageScaled(baseAddress + "." + cont.getTotalElements() + this.getType(), tex, 0, 0, this.xSize, this.ySize);
        cont.addElement(e);
    }

    public static class GOImageSerializer
    implements IJsonSerializer<GOImage> {
        public GOImage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement ye;
            JsonElement xe;
            JsonElement yl;
            JsonElement xl;
            JsonElement loc;
            JsonElement ys;
            GOImage r = new GOImage();
            JsonObject jobj = json.getAsJsonObject();
            JsonElement xs = jobj.get("xsize");
            if (xs != null) {
                r.xSize = xs.getAsInt();
            }
            if ((ys = jobj.get("ysize")) != null) {
                r.ySize = ys.getAsInt();
            }
            if ((loc = jobj.get("location")) != null) {
                r.location = loc.getAsString();
            }
            if ((xl = jobj.get("xstart")) != null) {
                r.ySize = xl.getAsInt();
            }
            if ((yl = jobj.get("ystart")) != null) {
                r.ySize = yl.getAsInt();
            }
            if ((xe = jobj.get("xend")) != null) {
                r.ySize = xe.getAsInt();
            }
            if ((ye = jobj.get("yend")) != null) {
                r.ySize = ye.getAsInt();
            }
            return r;
        }

        public JsonElement serialize(GOImage src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject r = new JsonObject();
            r.addProperty("type", src.getType());
            r.addProperty("xsize", (Number)src.xSize);
            r.addProperty("ysize", (Number)src.ySize);
            r.addProperty("location", src.location);
            r.addProperty("xstart", (Number)src.xStart);
            r.addProperty("ystart", (Number)src.yStart);
            r.addProperty("xend", (Number)src.xEnd);
            r.addProperty("yend", (Number)src.yEnd);
            return r;
        }
    }
}

