/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.m_guide.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.core.io.json.IJsonSerializer;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vliblegacy.lib.json.JsonUtils;
import com.valkyrieofnight.vliblegacy.lib.util.ConditionFactoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.GuiGuidePage;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.ModGuide;
import com.valkyrieofnight.vliblegacy.m_guide.json.GuideHandler;
import com.valkyrieofnight.vliblegacy.m_guide.json.objects.GuideObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class GuidePage
implements Comparable<GuidePage> {
    public static final GuidePage BLANK = new GuidePage();
    public static final String TYPE = "type";
    public int pageNumber;
    public List<String> menuItems = new ArrayList<String>();
    public String address;
    public String title;
    public String conditionFactory;
    List<GuideObject> content;

    public String getPageAddress() {
        return this.address;
    }

    public String getPageTitle() {
        return this.title;
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String is : this.menuItems) {
            ItemStack stack = JsonUtils.getFromString(is);
            if (stack == ItemStack.field_190927_a) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public GuiGuidePage addPage(final ModGuide.GuideTOCPage mainMenu, int xSize) {
        IConditionFactory cf = ConditionFactoryUtil.getConditionFactoryOrGenericTrue(this.conditionFactory);
        if (!cf.parse(new JsonContext(this.address), new JsonObject()).getAsBoolean()) {
            return null;
        }
        GuiGuidePage page = new GuiGuidePage(this.address, xSize){

            @Override
            public void addElements() {
                ArrayList ele = new ArrayList();
                for (GuideObject go : GuidePage.this.content) {
                    go.initElement(this.elementID, this);
                }
                for (VLElement vlElement : ele) {
                    this.addElement(vlElement);
                }
                mainMenu.addMenuButton(GuidePage.this.address, GuidePage.this.getStacks(), LangUtil.toLoc(GuidePage.this.title));
            }
        };
        mainMenu.addPage(page);
        return page;
    }

    public String toString() {
        String str = "{" + this.address + ":" + this.title + ":";
        int i = 0;
        for (GuideObject guideObject : this.content) {
            str = str + guideObject.toString();
            if (i >= this.content.size()) continue;
            str = str + ",";
        }
        return str + "}";
    }

    @Override
    public int compareTo(GuidePage arg0) {
        if (arg0 == null) {
            return -1;
        }
        if (this.pageNumber > arg0.pageNumber) {
            return 1;
        }
        if (this.pageNumber == arg0.pageNumber) {
            return 0;
        }
        return -1;
    }

    public static class GuidePageSerializer
    implements IJsonSerializer<GuidePage> {
        public GuidePage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement ti;
            JsonElement ad;
            JsonElement mit;
            GuidePage r = new GuidePage();
            JsonObject jobj = json.getAsJsonObject();
            JsonElement pn = jobj.get("pagenumber");
            if (pn != null) {
                r.pageNumber = pn.getAsInt();
            }
            if ((mit = jobj.get("menuitems")) != null) {
                r.menuItems = (List)context.deserialize(mit, List.class);
            }
            if ((ad = jobj.get("address")) != null) {
                r.address = ad.getAsString();
            }
            if ((ti = jobj.get("title")) != null) {
                r.title = ti.getAsString();
            }
            JsonArray jarr = jobj.get("content").getAsJsonArray();
            r.content = new ArrayList<GuideObject>();
            for (JsonElement je : jarr) {
                String type = je.getAsJsonObject().get(GuidePage.TYPE).getAsString();
                Class c = GuideHandler.getTypes().get(type);
                if (c == null) {
                    // empty if block
                }
                r.content.add((GuideObject)context.deserialize(je, (Type)c));
            }
            JsonElement conditionFactory = jobj.get("condition");
            if (conditionFactory != null) {
                r.conditionFactory = conditionFactory.getAsString();
            }
            return r;
        }

        public JsonElement serialize(GuidePage src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jobj = new JsonObject();
            jobj.addProperty("address", src.address);
            jobj.addProperty("title", src.title);
            jobj.add("menuitems", context.serialize(src.menuItems, List.class));
            JsonArray jarr = new JsonArray();
            for (GuideObject go : src.content) {
                String type = go.getType();
                Class c = GuideHandler.getTypes().get(type);
                if (c == null) {
                    // empty if block
                }
                jarr.add(context.serialize((Object)go, (Type)c));
            }
            jobj.addProperty("condition", src.conditionFactory);
            jobj.add("content", (JsonElement)jarr);
            return jobj;
        }
    }
}

