/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.client.gui.elements;

import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGui;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiPositioning;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiSaveLoad;
import javax.annotation.Nonnull;

public abstract class VLElement
implements IGuiPositioning,
IGuiSaveLoad {
    protected VLGui gui;
    protected String elementID;
    protected boolean init = false;
    protected int xPosOffset = 0;
    protected int yPosOffset = 0;
    protected int xSize = 0;
    protected int ySize = 0;

    public VLElement(String elementID) {
        this.elementID = elementID;
    }

    public void setGui(VLGui gui) {
        this.gui = gui;
        if (!this.init) {
            this.init = true;
            this.init();
        }
    }

    public abstract void init();

    public String getID() {
        return this.elementID;
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    @Override
    public void setXSize(int xSize) {
        this.xSize = xSize;
        this.gui.onElementResize(this);
    }

    @Override
    public void setYSize(int ySize) {
        this.ySize = ySize;
        this.gui.onElementResize(this);
    }

    @Override
    public int getXPosActual() {
        return this.gui.getGuiLeft() + this.xPosOffset;
    }

    @Override
    public int getYPosActual() {
        return this.gui.getGuiTop() + this.yPosOffset;
    }

    @Override
    public int getXPosOffset() {
        return this.xPosOffset;
    }

    @Override
    public int getYPosOffset() {
        return this.yPosOffset;
    }

    @Override
    public void setXPosOffset(int xPos) {
        this.xPosOffset = xPos;
        this.gui.onElementResize(this);
    }

    @Override
    public void setYPosOffset(int yPos) {
        this.yPosOffset = yPos;
        this.gui.onElementResize(this);
    }

    public static enum Justified {
        LEFT,
        CENTER,
        RIGHT;


        public int getOffset(int objectWidth) {
            switch (this) {
                case LEFT: {
                    return 0;
                }
                case CENTER: {
                    return -(objectWidth / 2);
                }
                case RIGHT: {
                    return -objectWidth;
                }
            }
            return 0;
        }
    }

    public static enum VAlignment {
        TOP("top"),
        CENTER("center"),
        BOTTOM("bottom");

        final String name;

        private VAlignment(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset(int objectHeight) {
            switch (this) {
                case TOP: {
                    return 0;
                }
                case CENTER: {
                    return -(objectHeight / 2);
                }
                case BOTTOM: {
                    return -objectHeight;
                }
            }
            return 0;
        }

        public static VAlignment fromString(String str) {
            if (str.equalsIgnoreCase("center")) {
                return CENTER;
            }
            if (str.equalsIgnoreCase("bottom")) {
                return BOTTOM;
            }
            return TOP;
        }
    }

    @Nonnull
    public static enum HAlignment {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        final String name;

        private HAlignment(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Nonnull
        public static HAlignment getFromName(@Nonnull String name) {
            if (name == "left") {
                return LEFT;
            }
            if (name == "center") {
                return CENTER;
            }
            return RIGHT;
        }

        public int getOffset(int objectWidth) {
            switch (this) {
                case LEFT: {
                    return 0;
                }
                case CENTER: {
                    return -(objectWidth / 2);
                }
                case RIGHT: {
                    return -objectWidth;
                }
            }
            return 0;
        }

        @Nonnull
        public static HAlignment fromString(@Nonnull String str) {
            if (str.equalsIgnoreCase("center")) {
                return CENTER;
            }
            if (str.equalsIgnoreCase("right")) {
                return RIGHT;
            }
            return LEFT;
        }
    }
}

