/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import java.util.List;
import javax.annotation.Nonnull;
import scala.actors.threadpool.Arrays;

public abstract class PropBase<T> {
    public static final String SEPARATOR = ":";
    protected List<String> unlocalizedDocumentation = Lists.newArrayList();
    protected String id;
    private boolean enabled = false;
    protected T dataDefault;
    protected T data;

    public PropBase(T data) {
        this.data = data;
    }

    public PropBase(T data, T dataDefault) {
        this.data = data;
        this.dataDefault = dataDefault;
    }

    public final String getPrefix() {
        return this.getParser().getPrefix();
    }

    public final String getId() {
        return this.id;
    }

    public final String getMapKey() {
        return this.generateKey(this.id);
    }

    public String getExtra() {
        return "";
    }

    public final List<String> getDocumentation() {
        return this.unlocalizedDocumentation;
    }

    public final boolean isEnabled() {
        return this.forceEnabled() ? true : this.enabled;
    }

    public boolean forceEnabled() {
        return false;
    }

    public PropBase setDefaultValue(T dataDefault) {
        this.dataDefault = dataDefault;
        return this;
    }

    public final PropBase setId(String id) {
        this.id = id;
        return this;
    }

    public final PropBase setDocumentation(String ... unlocalizedDocumentation) {
        this.unlocalizedDocumentation = Lists.newArrayList();
        this.unlocalizedDocumentation.addAll(Arrays.asList((Object[])unlocalizedDocumentation));
        return this;
    }

    public final T getValue() {
        this.enabled = true;
        this.validateData();
        return this.data;
    }

    public final T getDefaultValue() {
        return this.dataDefault;
    }

    public final void validateData() {
        this.data = this.validateData(this.data);
    }

    protected abstract T validateData(T var1);

    @Nonnull
    public abstract PropParserBase getParser();

    public final String generateKey(String id) {
        return this.getParser().getPrefix() + SEPARATOR + id;
    }
}

