/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.lemonlib.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.lemonlib.item.IItemModel;
import party.lemons.lemonlib.item.ItemRegistry;
import party.lemons.lemonlib.util.Pair;

@Mod.EventBusSubscriber(modid="lemonlib")
public class BlockRegistry {
    private static List<Block> blockList = new ArrayList<Block>();
    private static List<Pair<Block, String[]>> oreDict = new ArrayList<Pair<Block, String[]>>();
    private static String MODID = "lemonlib";
    private static CreativeTabs TAB = null;
    private static IForgeRegistry<Block> REGISTRY;

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        blockList.stream().filter(b -> b instanceof IItemModel && ((IItemModel)b).hasModel()).forEach(b -> BlockRegistry.registerItemBlock((IForgeRegistry<Item>)event.getRegistry(), b));
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        ItemBlock ib = new ItemBlock(block);
        ib.setRegistryName(block.getRegistryName());
        ItemRegistry.getItemList().add((Item)ib);
        registry.register((IForgeRegistryEntry)ib);
    }

    public static Block setProperties(Block block, float hardness, float resistence, float light) {
        return block.func_149711_c(hardness).func_149752_b(resistence).func_149715_a(light);
    }

    public static Block registerBlock(Block block, String name, String ... oreDict) {
        return BlockRegistry.registerBlock(block, name, MODID, true, oreDict);
    }

    public static Block registerBlock(Block block, String name, String domain, boolean addDomainToUnloc, String ... ores) {
        String unloc = addDomainToUnloc ? domain + "." : "";
        block.func_149663_c(unloc + name);
        block.setRegistryName(domain, name);
        if (TAB != null) {
            block.func_149647_a(TAB);
        }
        if (ores.length > 0) {
            oreDict.add(Pair.of(block, ores));
        }
        blockList.add(block);
        REGISTRY.register((IForgeRegistryEntry)block);
        return block;
    }

    public static void setup(String modid, IForgeRegistry<Block> registry, CreativeTabs tab) {
        MODID = modid;
        TAB = tab;
        REGISTRY = registry;
    }

    public static List<Block> getBlockList() {
        return blockList;
    }

    public static List<Pair<Block, String[]>> getOreDictEntries() {
        return oreDict;
    }
}

