/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ChargerManager {
    private static Map<ComparableItemStackValidated, ChargerRecipe> recipeMap = new Object2ObjectOpenHashMap();
    public static final int DEFAULT_ENERGY = 8000;

    public static ChargerRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = new ComparableItemStackValidated(input);
        ChargerRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return ChargerManager.getRecipe(input) != null;
    }

    public static ChargerRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new ChargerRecipe[0]);
    }

    public static void initialize() {
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackValidated, ChargerRecipe> entry : recipeMap.entrySet()) {
            ChargerRecipe tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackValidated(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static ChargerRecipe addRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || ChargerManager.recipeExists(input)) {
            return null;
        }
        ChargerRecipe recipe = new ChargerRecipe(input, output, energy);
        recipeMap.put(new ComparableItemStackValidated(input), recipe);
        return recipe;
    }

    public static ChargerRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(new ComparableItemStackValidated(input));
    }

    public static class ChargerRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        public ChargerRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

