/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.charger;

import cofh.thermalexpansion.block.machine.TileCharger;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ChargerRecipeWrapper
extends BaseRecipeWrapper {
    protected List<ItemStack> inputs;
    protected List<ItemStack> outputs;
    protected IDrawableAnimated progress;

    public ChargerRecipeWrapper(IGuiHelper guiHelper, ChargerManager.ChargerRecipe recipe) {
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        recipeInputs.add(recipe.getInput());
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        recipeOutputs.add(recipe.getOutput());
        this.inputs = recipeInputs;
        this.outputs = recipeOutputs;
        this.energy = recipe.getEnergy();
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getScaleFill(6);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, Math.max(10, this.energy / TileCharger.basePower), IDrawableAnimated.StartDirection.BOTTOM, false);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progress.draw(minecraft, 34, 43);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

