/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.fluid.FluidTankCore;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoSteam;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoSteam;
import cofh.thermalexpansion.util.managers.dynamo.SteamManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoSteam
extends TileDynamoBase {
    protected static final EnergyConfig ENERGY_CONFIG = new EnergyConfig();
    protected static final HashSet<String> VALID_AUGMENTS = new HashSet();
    public static boolean enable = true;
    public static int basePower = 40;
    public static int fluidAmount = 100;
    public static final int STEAM_RF = 25000;
    public static final int STEAM_MINIMUM = 2000;
    private FluidTankCore tank = new FluidTankCore(4000);
    private int waterRF;
    protected boolean augmentTurbine;

    public static void initialize() {
        VALID_AUGMENTS.addAll(VALID_AUGMENTS_BASE);
        VALID_AUGMENTS.add("dynamoBoiler");
        VALID_AUGMENTS.add("dynamoSteamTurbine");
        GameRegistry.registerTileEntity(TileDynamoSteam.class, (String)"thermalexpansion:dynamo_steam");
        TileDynamoSteam.config();
    }

    public static void config() {
        String category = "Dynamo.Steam";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Steam Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 1000, comment);
        ENERGY_CONFIG.setDefaultParams(basePower, smallStorage);
    }

    public TileDynamoSteam() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.tank.setLock(FluidRegistry.WATER);
    }

    protected String getTileName() {
        return "tile.thermalexpansion.dynamo.steam.name";
    }

    @Override
    protected EnergyConfig getEnergyConfig() {
        return ENERGY_CONFIG;
    }

    @Override
    protected HashSet<String> getValidAugments() {
        return VALID_AUGMENTS;
    }

    @Override
    protected boolean canStart() {
        if (this.augmentTurbine) {
            return this.tank.getFluidAmount() > 2000;
        }
        return !(this.waterRF <= 0 && this.tank.getFluidAmount() < fluidAmount || this.fuelRF <= 0 && SteamManager.getFuelEnergy(this.inventory[0]) <= 0);
    }

    @Override
    protected boolean canFinish() {
        if (this.augmentTurbine) {
            return this.tank.getFluidAmount() <= 2000 || !this.redstoneControlOrDisable();
        }
        return this.fuelRF <= 0 || this.waterRF <= 0;
    }

    @Override
    protected void processStart() {
        if (this.augmentTurbine) {
            return;
        }
        if (this.fuelRF <= 0) {
            this.maxFuelRF = SteamManager.getFuelEnergy(this.inventory[0]) * this.energyMod / 100;
            this.fuelRF += this.maxFuelRF;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
        if (this.waterRF <= 0) {
            this.waterRF += 25000;
            this.tank.modifyFluidStored(-fluidAmount);
        }
    }

    @Override
    protected int processTick() {
        if (this.augmentBoiler) {
            this.fuelRF -= this.energyConfig.maxPower;
            this.waterRF -= this.energyConfig.maxPower;
            this.transferSteam();
            return this.energyConfig.maxPower;
        }
        if (this.augmentTurbine) {
            this.lastEnergy = Math.min(this.calcEnergy(), 2 * (this.tank.getFluidAmount() - 2000));
            this.energyStorage.modifyEnergyStored(this.lastEnergy);
            this.tank.modifyFluidStored(-this.lastEnergy / 2);
            this.transferEnergy();
            return this.lastEnergy;
        }
        this.lastEnergy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(this.lastEnergy);
        this.fuelRF -= this.lastEnergy;
        this.waterRF -= this.lastEnergy;
        this.transferEnergy();
        return this.lastEnergy;
    }

    @Override
    protected void processIdle() {
        if (this.augmentTurbine) {
            this.tank.modifyFluidStored(-250);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)TFFluids.fluidSteam.getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoSteam(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoSteam(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, SteamManager.DEFAULT_ENERGY);
        }
        return this.fuelRF * scale / this.maxFuelRF;
    }

    @Override
    public FluidTankCore getTank(int tankIndex) {
        return this.tank;
    }

    @Override
    public boolean showSteamTab() {
        return this.augmentBoiler || this.augmentTurbine;
    }

    @Override
    public int getFuelEnergy(ItemStack stack) {
        return (this.augmentTurbine ? 0 : SteamManager.getFuelEnergy(stack)) * this.energyMod / 100;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxFuelRF = nbt.func_74762_e("FuelMax");
        this.waterRF = nbt.func_74762_e("Water");
        this.tank.readFromNBT(nbt);
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, SteamManager.DEFAULT_ENERGY);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.maxFuelRF);
        nbt.func_74768_a("Water", this.waterRF);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentTurbine);
        payload.addInt(this.maxFuelRF);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addBool(this.augmentTurbine);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentTurbine = payload.getBool();
        this.maxFuelRF = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.augmentTurbine = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentTurbine = false;
        this.tank.clearLocked();
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (this.augmentTurbine) {
            this.tank.setLock(TFFluids.fluidSteam);
        } else {
            this.tank.setLock(FluidRegistry.WATER);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentBoiler && "dynamoBoiler".equals(id)) {
            this.augmentBoiler = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 3 * this.getBasePower(this.level), smallStorage);
            this.energyStorage.setEnergyStored(0);
            this.energyMod += 15;
            return true;
        }
        if (!this.augmentTurbine && "dynamoSteamTurbine".equals(id)) {
            this.augmentTurbine = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 3 * this.getBasePower(this.level), smallStorage);
            this.fuelRF = 0;
            this.waterRF = 0;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public int getInfoSteamPerTick() {
        if (!this.isActive) {
            return 0;
        }
        if (this.augmentTurbine) {
            return this.lastEnergy / 2;
        }
        return this.augmentBoiler ? this.energyConfig.maxPower : this.lastEnergy;
    }

    @Override
    public int getInfoMaxSteamPerTick() {
        return this.augmentTurbine ? this.energyConfig.maxPower / 2 : this.energyConfig.maxPower;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return !this.augmentTurbine && SteamManager.getFuelEnergy(stack) > 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == null || side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{TileDynamoSteam.this.tank.getInfo()});
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileDynamoSteam.this.augmentCoilDuct || from.ordinal() != TileDynamoSteam.this.facing) {
                        if (TileDynamoSteam.this.augmentTurbine) {
                            if (resource.getFluid() == TFFluids.fluidSteam) {
                                return TileDynamoSteam.this.tank.fill(resource, doFill);
                            }
                            return 0;
                        }
                        if (resource.getFluid() == FluidRegistry.WATER) {
                            return TileDynamoSteam.this.tank.fill(resource, doFill);
                        }
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileDynamoSteam.this.augmentCoilDuct || from.ordinal() != TileDynamoSteam.this.facing) {
                        return TileDynamoSteam.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileDynamoSteam.this.augmentCoilDuct || from.ordinal() != TileDynamoSteam.this.facing) {
                        return TileDynamoSteam.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

