/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.utils.ArmorTagUtil;
import c4.conarm.lib.armor.ArmorNBT;
import c4.conarm.lib.traits.AbstractArmorTrait;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public abstract class TraitProgressiveArmorStats
extends AbstractArmorTrait {
    protected final String pool_key;
    protected final String applied_key;

    public TraitProgressiveArmorStats(String identifier, TextFormatting color) {
        super(identifier, color);
        this.pool_key = identifier + "StatPool";
        this.applied_key = identifier + "StatBonus";
    }

    public TraitProgressiveArmorStats(String identifier, int color) {
        super(identifier, color);
        this.pool_key = identifier + "StatPool";
        this.applied_key = identifier + "StatBonus";
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ArmorNBT data = ArmorTagUtil.getArmorStats(rootCompound);
        StatNBT bonus = this.getBonus(rootCompound);
        data.durability += bonus.durability;
        data.defense += bonus.defense;
        data.toughness += bonus.toughness;
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)data.get());
    }

    protected boolean hasPool(NBTTagCompound root) {
        return TagUtil.getExtraTag((NBTTagCompound)root).func_74764_b(this.pool_key);
    }

    protected StatNBT getPool(NBTTagCompound root) {
        return TraitProgressiveArmorStats.getStats(root, this.pool_key);
    }

    protected void setPool(NBTTagCompound root, StatNBT data) {
        TraitProgressiveArmorStats.setStats(root, data, this.pool_key);
    }

    protected StatNBT getBonus(NBTTagCompound root) {
        return TraitProgressiveArmorStats.getStats(root, this.applied_key);
    }

    protected void setBonus(NBTTagCompound root, StatNBT data) {
        TraitProgressiveArmorStats.setStats(root, data, this.applied_key);
    }

    protected static StatNBT getStats(NBTTagCompound root, String key) {
        return (StatNBT)ModifierNBT.readTag((NBTTagCompound)TagUtil.getTagSafe((NBTTagCompound)TagUtil.getExtraTag((NBTTagCompound)root), (String)key), StatNBT.class);
    }

    protected static void setStats(NBTTagCompound root, StatNBT data, String key) {
        NBTTagCompound extra = TagUtil.getExtraTag((NBTTagCompound)root);
        NBTTagCompound tag = new NBTTagCompound();
        data.write(tag);
        extra.func_74782_a(key, (NBTBase)tag);
        TagUtil.setExtraTag((NBTTagCompound)root, (NBTTagCompound)extra);
    }

    public static class StatNBT
    extends ModifierNBT {
        public int durability;
        public float defense;
        public float toughness;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.durability = tag.func_74762_e("durability");
            this.defense = tag.func_74760_g("defense");
            this.toughness = tag.func_74760_g("toughness");
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("durability", this.durability);
            tag.func_74776_a("defense", this.defense);
            tag.func_74776_a("toughness", this.toughness);
        }
    }
}

