/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.traits.TraitProgressiveArmorStats;
import c4.conarm.common.armor.utils.ArmorTagUtil;
import c4.conarm.lib.armor.ArmorNBT;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.utils.TagUtil;

public class TraitAlien
extends TraitProgressiveArmorStats {
    protected static final int TICK_PER_STAT = 72;
    protected static final int DURABILITY_STEP = 1;
    protected static final float TOUGHNESS_STEP = 0.01f;
    protected static final float DEFENSE_STEP = 0.02f;

    public TraitAlien() {
        super("alien", TextFormatting.YELLOW);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        if (!this.hasPool(rootCompound)) {
            TraitProgressiveArmorStats.StatNBT data = new TraitProgressiveArmorStats.StatNBT();
            block5: for (int statPoints = 800; statPoints > 0; --statPoints) {
                switch (random.nextInt(3)) {
                    case 0: {
                        ++data.durability;
                        continue block5;
                    }
                    case 1: {
                        data.toughness += 0.01f;
                        continue block5;
                    }
                    case 2: {
                        data.defense += 0.02f;
                    }
                }
            }
            this.setPool(rootCompound, data);
        }
        super.applyEffect(rootCompound, modifierTag);
    }

    public void onArmorTick(ItemStack armor, World world, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70173_aa % 72 > 0) {
            return;
        }
        NBTTagCompound root = TagUtil.getTagSafe((ItemStack)armor);
        TraitProgressiveArmorStats.StatNBT pool = this.getPool(root);
        TraitProgressiveArmorStats.StatNBT distributed = this.getBonus(root);
        ArmorNBT data = ArmorTagUtil.getArmorStats(armor);
        if (player.field_70173_aa % 216 == 0) {
            if (distributed.defense < pool.defense) {
                data.defense += 0.02f;
                distributed.defense += 0.02f;
            }
        } else if (player.field_70173_aa % 144 == 0) {
            if (distributed.toughness < pool.toughness) {
                data.toughness += 0.01f;
                distributed.toughness += 0.01f;
            }
        } else if (distributed.durability < pool.durability) {
            ++data.durability;
            ++distributed.durability;
        }
        TagUtil.setToolTag((NBTTagCompound)root, (NBTTagCompound)data.get());
        this.setBonus(root, distributed);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        TraitProgressiveArmorStats.StatNBT pool = this.getBonus(TagUtil.getTagSafe((ItemStack)tool));
        return ImmutableList.of((Object)CoreMaterialStats.formatDurability(pool.durability), (Object)CoreMaterialStats.formatDefense(pool.defense), (Object)PlatesMaterialStats.formatToughness(pool.toughness));
    }
}

