/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers.accessories;

import c4.conarm.client.models.accessories.ModelGoggles;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.modifiers.IAccessoryRender;
import c4.conarm.lib.modifiers.IToggleable;
import c4.conarm.lib.utils.ConstructUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;

public abstract class AbstractTravelGoggles
extends AccessoryModifier
implements IAccessoryRender,
IToggleable {
    private static final String TAG_GOGGLES = "goggles";
    @SideOnly(value=Side.CLIENT)
    private static ModelGoggles model;
    private static ResourceLocation texture;
    public VisionType visionType;

    public AbstractTravelGoggles(VisionType vision) {
        super(vision.identifier);
        this.visionType = vision;
    }

    public VisionType getVisionType() {
        return this.visionType;
    }

    @Override
    public void onKeybinding(ItemStack armor, EntityPlayer player) {
        this.toggleGoggles(armor);
    }

    private void toggleGoggles(ItemStack stack) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)stack, (String)this.getModifierIdentifier());
        GogglesData data = (GogglesData)modtag.getTagData(GogglesData.class);
        data.goggles = !data.goggles;
        modtag.save();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onAccessoryRender(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (model == null) {
            model = new ModelGoggles();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    @Override
    public boolean getToggleStatus(ItemStack stack) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)stack, (String)this.getModifierIdentifier());
        GogglesData data = (GogglesData)modtag.getTagData(GogglesData.class);
        return data.goggles;
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD && super.canApplyCustom(stack);
    }

    static {
        texture = ConstructUtils.getResource("textures/models/accessories/travel_goggles.png");
    }

    static enum VisionType {
        ZOOM("travel_goggles"),
        NIGHT_VISION("night_vision"),
        SOUL("soul_sight");

        String identifier;

        private VisionType(String identifier) {
            this.identifier = identifier;
        }
    }

    public static class GogglesData
    extends ModifierNBT {
        public boolean goggles = false;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.goggles = tag.func_74767_n(AbstractTravelGoggles.TAG_GOGGLES);
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74757_a(AbstractTravelGoggles.TAG_GOGGLES, this.goggles);
        }
    }
}

