/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers.accessories;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.modifiers.IToggleable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;

public abstract class AbstractToggleAccessoryModifier
extends AccessoryModifier
implements IToggleable {
    private static final String TAG_TOGGLE = "toggle";
    protected boolean damagesArmor;

    public AbstractToggleAccessoryModifier(String identifier, boolean damagesArmor) {
        super(identifier);
        this.damagesArmor = damagesArmor;
    }

    public void onArmorTick(ItemStack armor, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.damagesArmor && player.field_70173_aa % 100 == 0 && this.getToggleData((ItemStack)armor).toggle) {
            ArmorHelper.damageArmor(armor, DamageSource.field_76377_j, 1, player, EntityLiving.func_184640_d((ItemStack)armor).func_188454_b());
        }
    }

    @Override
    public void onKeybinding(ItemStack armor, EntityPlayer player) {
        this.toggle(armor, player);
    }

    private void toggle(ItemStack stack, EntityPlayer player) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)stack, (String)this.getModifierIdentifier());
        ToggleData data = (ToggleData)modtag.getTagData(ToggleData.class);
        if (!data.toggle && this.damagesArmor) {
            ArmorHelper.damageArmor(stack, DamageSource.field_76377_j, 3, player, EntityLiving.func_184640_d((ItemStack)stack).func_188454_b());
        }
        data.toggle = !data.toggle;
        modtag.save();
    }

    protected ToggleData getToggleData(ItemStack stack) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)stack, (String)this.getModifierIdentifier());
        return (ToggleData)modtag.getTagData(ToggleData.class);
    }

    @Override
    public boolean getToggleStatus(ItemStack stack) {
        return this.getToggleData((ItemStack)stack).toggle;
    }

    public static class ToggleData
    extends ModifierNBT {
        public boolean toggle = false;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.toggle = tag.func_74767_n(AbstractToggleAccessoryModifier.TAG_TOGGLE);
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74757_a(AbstractToggleAccessoryModifier.TAG_TOGGLE, this.toggle);
        }
    }
}

