/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common;

import c4.conarm.common.blocks.BlockArmorForge;
import c4.conarm.common.blocks.BlockArmorStation;
import c4.conarm.common.blocks.BlockSoftObsidian;
import c4.conarm.common.items.AccessoryBase;
import c4.conarm.common.items.ItemArmoryBook;
import c4.conarm.common.items.ItemBase;
import c4.conarm.common.items.ItemConarmMat;
import c4.conarm.common.items.ItemPolishingKit;
import c4.conarm.common.items.armor.Boots;
import c4.conarm.common.items.armor.Chestplate;
import c4.conarm.common.items.armor.Helmet;
import c4.conarm.common.items.armor.Leggings;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.armor.ArmorPart;
import c4.conarm.lib.utils.ConstructUtils;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.tools.TinkerTools;

public class ConstructsRegistry {
    public static List<Pair<Item, ArmorPart>> armorPartPatterns = Lists.newLinkedList();
    public static AccessoryBase travelBelt;
    public static AccessoryBase travelPotion;
    public static AccessoryBase travelSack;
    public static AccessoryBase travelGoggles;
    public static AccessoryBase travelNight;
    public static AccessoryBase travelSoul;
    public static AccessoryBase travelSneak;
    public static AccessoryBase travelSlowFall;
    public static BlockArmorForge armorForge;
    public static BlockArmorStation armorStation;
    public static BlockSoftObsidian softObsidian;
    public static ArmorPart helmetCore;
    public static ArmorPart armorTrim;
    public static ArmorPart armorPlate;
    public static ArmorPart chestCore;
    public static ArmorPart leggingsCore;
    public static ArmorPart bootsCore;
    public static ArmorCore helmet;
    public static ArmorCore chestplate;
    public static ArmorCore leggings;
    public static ArmorCore boots;
    public static ItemArmoryBook book;
    public static ItemPolishingKit polishingKit;
    public static ItemBase invisibleInk;
    public static ItemBase resistMat;
    public static ItemBase fireResistMat;
    public static ItemBase projResistMat;
    public static ItemBase blastResistMat;
    public static ItemBase gauntletMat;
    public static ItemBase gauntletAttack;
    public static ItemBase gauntletSpeed;
    public static ItemBase gauntletReach;
    public static ItemBase frostySoles;
    public static ItemBase travelCloak;
    public static ItemBase travelBeltBase;
    public static ItemBase travelGogglesBase;

    public static void registerArmorParts(IForgeRegistry<Item> registry) {
        helmetCore = ConstructsRegistry.registerArmorPart(registry, new ArmorPart(576, EntityEquipmentSlot.HEAD), "helmet_core");
        armorTrim = ConstructsRegistry.registerArmorPart(registry, new ArmorPart(144), "armor_trim");
        armorPlate = ConstructsRegistry.registerArmorPart(registry, new ArmorPart(432), "armor_plate");
        chestCore = ConstructsRegistry.registerArmorPart(registry, new ArmorPart(864, EntityEquipmentSlot.CHEST), "chest_core");
        leggingsCore = ConstructsRegistry.registerArmorPart(registry, new ArmorPart(720, EntityEquipmentSlot.LEGS), "leggings_core");
        bootsCore = ConstructsRegistry.registerArmorPart(registry, new ArmorPart(576, EntityEquipmentSlot.FEET), "boots_core");
    }

    public static void initModels() {
        travelBeltBase.initModel();
        travelBelt.initModel();
        travelPotion.initModel();
        travelSack.initModel();
        travelGogglesBase.initModel();
        travelGoggles.initModel();
        travelNight.initModel();
        travelSoul.initModel();
        travelCloak.initModel();
        travelSlowFall.initModel();
        travelSneak.initModel();
        book.initModel();
        resistMat.initModel();
        fireResistMat.initModel();
        projResistMat.initModel();
        blastResistMat.initModel();
        gauntletMat.initModel();
        gauntletAttack.initModel();
        gauntletSpeed.initModel();
        gauntletReach.initModel();
        invisibleInk.initModel();
        frostySoles.initModel();
    }

    public static void registerArmorPieces(IForgeRegistry<Item> registry) {
        helmet = ConstructsRegistry.registerArmorPiece(registry, new Helmet("classic"), "helmet");
        chestplate = ConstructsRegistry.registerArmorPiece(registry, new Chestplate("classic"), "chestplate");
        leggings = ConstructsRegistry.registerArmorPiece(registry, new Leggings("classic"), "leggings");
        boots = ConstructsRegistry.registerArmorPiece(registry, new Boots("classic"), "boots");
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        book = ConstructUtils.registerItem(registry, new ItemArmoryBook(), "book");
        invisibleInk = ConstructUtils.registerItem(registry, new ItemConarmMat(), "invisible_ink");
        resistMat = ConstructUtils.registerItem(registry, new ItemConarmMat(), "resist_mat");
        fireResistMat = ConstructUtils.registerItem(registry, new ItemConarmMat(), "resist_mat_fire");
        projResistMat = ConstructUtils.registerItem(registry, new ItemConarmMat(), "resist_mat_proj");
        blastResistMat = ConstructUtils.registerItem(registry, new ItemConarmMat(), "resist_mat_blast");
        gauntletMat = ConstructUtils.registerItem(registry, new ItemBase(), "gauntlet_mat");
        gauntletSpeed = ConstructUtils.registerItem(registry, new ItemConarmMat(), "gauntlet_mat_speed");
        gauntletAttack = ConstructUtils.registerItem(registry, new ItemConarmMat(), "gauntlet_mat_attack");
        gauntletReach = ConstructUtils.registerItem(registry, new ItemConarmMat(), "gauntlet_mat_reach");
        frostySoles = ConstructUtils.registerItem(registry, new ItemConarmMat(), "frosty_soles");
        travelBeltBase = ConstructUtils.registerItem(registry, new ItemBase(), "travel_belt_base");
        travelBelt = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.LEGS), "travel_belt");
        travelPotion = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.LEGS), "travel_potion");
        travelSack = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.CHEST), "travel_sack");
        travelGogglesBase = ConstructUtils.registerItem(registry, new ItemBase(), "travel_goggles_base");
        travelGoggles = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.HEAD), "travel_goggles");
        travelNight = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.HEAD), "travel_night");
        travelCloak = ConstructUtils.registerItem(registry, new ItemBase(), "travel_cloak");
        travelSneak = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.CHEST), "travel_sneak");
        travelSlowFall = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.CHEST), "travel_slowfall");
        travelSoul = ConstructUtils.registerItem(registry, new AccessoryBase(EntityEquipmentSlot.HEAD), "travel_soul");
        polishingKit = (ItemPolishingKit)ConstructsRegistry.registerArmorPart(registry, new ItemPolishingKit(), "polishing_kit");
        polishingKit.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        TinkerRegistry.registerToolPart((IToolPart)polishingKit);
        TinkerRegistry.registerStencilTableCrafting((ItemStack)Pattern.setTagForPart((ItemStack)new ItemStack((Item)TinkerTools.pattern), (Item)polishingKit));
    }

    private static <T extends ArmorCore> T registerArmorPiece(IForgeRegistry<Item> registry, T item, String name) {
        for (PartMaterialType pmt : item.getRequiredComponents()) {
            for (IToolPart ap : pmt.getPossibleParts()) {
                TinkerRegistry.registerToolPart((IToolPart)ap);
            }
        }
        return ConstructUtils.registerItem(registry, item, name);
    }

    private static ArmorPart registerArmorPart(IForgeRegistry<Item> registry, ArmorPart part, String name) {
        return ConstructsRegistry.registerArmorPart(registry, part, name, TinkerTools.pattern);
    }

    private static <T extends Item> ArmorPart registerArmorPart(IForgeRegistry<Item> registry, ArmorPart part, String name, T pattern) {
        ArmorPart ret = ConstructUtils.registerItem(registry, part, name);
        ArmoryRegistry.armorParts.add(ret);
        if (pattern != null) {
            armorPartPatterns.add((Pair<Item, ArmorPart>)Pair.of(pattern, (Object)((Object)ret)));
        }
        return ret;
    }
}

