/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import openblocks.OpenBlocks;
import openblocks.common.FluidXpUtils;
import openblocks.common.block.BlockXPShower;
import openblocks.common.entity.EntityXPOrbNoFly;
import openmods.OpenMods;
import openmods.liquids.GenericTank;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityXPShower
extends SyncedTileEntity
implements ITickable {
    private static final FluidStack XP_FLUID = new FluidStack(OpenBlocks.Fluids.xpJuice, 1);
    private static final int DRAIN_PER_CYCLE = 100;
    private static final int ORB_SPAWN_FREQUENCY = 3;
    private GenericTank bufferTank = new GenericTank(1000, FluidXpUtils.getAcceptedFluids());
    private SyncableBoolean particleSpawnerActive;
    private int particleSpawnTimer = 0;

    protected void createSyncedFields() {
        this.particleSpawnerActive = new SyncableBoolean();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.trySpawnXpOrbs();
        } else {
            this.trySpawnParticles();
        }
    }

    private void trySpawnXpOrbs() {
        boolean hasSpawnedParticle = false;
        if (OpenMods.proxy.getTicks(this.field_145850_b) % 3L == 0L && this.isPowered()) {
            int xpInTank;
            int xpInOrb;
            FluidXpUtils.IFluidXpConverter converter;
            int toDrain;
            this.bufferTank.fillFromSide(100, this.field_145850_b, this.field_174879_c, this.getBack());
            FluidStack tankContents = this.bufferTank.getFluid();
            Optional<FluidXpUtils.IFluidXpConverter> maybeConverter = FluidXpUtils.getConverter(tankContents);
            if (maybeConverter.isPresent() && (toDrain = (converter = maybeConverter.get()).xpToFluid(xpInOrb = EntityXPOrb.func_70527_a((int)(xpInTank = converter.fluidToXp(tankContents.amount))))) > 0 && toDrain <= tankContents.amount) {
                this.bufferTank.drain(toDrain, true);
                hasSpawnedParticle = true;
                BlockPos p = this.func_174877_v();
                this.field_145850_b.func_72838_d((Entity)new EntityXPOrbNoFly(this.field_145850_b, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.1, (double)p.func_177952_p() + 0.5, xpInOrb));
            }
        }
        this.particleSpawnerActive.set(hasSpawnedParticle);
        this.sync();
    }

    private boolean isPowered() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockXPShower && (Boolean)state.func_177229_b(BlockXPShower.POWERED) != false;
    }

    private void trySpawnParticles() {
        int particleLevel = OpenBlocks.proxy.getParticleSettings();
        if (particleLevel == 0 || particleLevel == 1 && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            int n = this.particleSpawnTimer = this.particleSpawnerActive.get() ? 10 : this.particleSpawnTimer - 1;
            if (this.particleSpawnTimer > 0) {
                BlockPos p = this.func_174877_v();
                Vec3d vec = new Vec3d((this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.05, 0.0, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.05);
                OpenBlocks.proxy.spawnLiquidSpray(this.field_145850_b, XP_FLUID, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.4, (double)p.func_177952_p() + 0.5, 0.4f, 0.7f, vec);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.bufferTank.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.bufferTank.writeToNBT(tag);
        return tag;
    }
}

