/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.api.IPaintableBlock;
import openblocks.common.CanvasReplaceBlacklist;
import openblocks.common.block.BlockCanvas;
import openmods.colors.ColorMeta;
import openmods.colors.ColorUtils;
import openmods.colors.RGB;
import openmods.infobook.BookDocumentation;
import openmods.utils.ItemUtils;

@BookDocumentation(customName="paintbrush", hasVideo=true)
public class ItemPaintBrush
extends Item {
    private static final int SINGLE_COLOR_THRESHOLD = 16;
    private static final String TAG_COLOR = "color";
    public static final int MAX_USES = 24;

    public ItemPaintBrush() {
        this.func_77625_d(1);
        this.func_77656_e(24);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> result, ITooltipFlag flag) {
        Integer color = ItemPaintBrush.getColorFromStack(stack);
        if (color != null) {
            result.add(String.format("#%06X", color));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
            for (ColorMeta color : ColorMeta.getAllColors()) {
                list.add((Object)ItemPaintBrush.createStackWithColor(color.rgb));
            }
        }
    }

    @Nonnull
    public static ItemStack createStackWithColor(int color) {
        ItemStack stack = new ItemStack(OpenBlocks.Items.paintBrush);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
        return stack;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        Integer color = ItemPaintBrush.getColorFromStack(stack);
        if (stack.func_77952_i() > 24 || color == null) {
            return EnumActionResult.FAIL;
        }
        int solidColor = 0xFF000000 | color;
        boolean changed = ItemPaintBrush.tryRecolorBlock(player, world, pos, facing, solidColor);
        if (!changed && Config.paintbrushReplacesBlocks && CanvasReplaceBlacklist.instance.isAllowedToReplace(world, pos) && BlockCanvas.replaceBlock(world, pos)) {
            changed = ItemPaintBrush.tryRecolorBlock(player, world, pos, facing, solidColor);
        }
        if (changed) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187886_fs, SoundCategory.PLAYERS, 0.1f, 0.8f);
            if (!player.field_71075_bZ.field_75098_d && stack.func_96631_a(1, player.func_70681_au(), player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null)) {
                NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
                tag.func_82580_o(TAG_COLOR);
                stack.func_77964_b(0);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private static boolean tryRecolorBlock(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, int color) {
        if (player.func_70093_af()) {
            return ItemPaintBrush.tryRecolorBlock(world, pos, color, EnumFacing.field_82609_l);
        }
        return ItemPaintBrush.tryRecolorBlock(world, pos, color, facing);
    }

    private static boolean tryRecolorBlock(World world, BlockPos pos, int rgb, EnumFacing ... sides) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IPaintableBlock) {
            IPaintableBlock paintableBlock = (IPaintableBlock)block;
            boolean result = false;
            for (EnumFacing dir : sides) {
                result |= paintableBlock.recolorBlock(world, pos, dir, rgb);
            }
            return result;
        }
        ColorMeta nearest = ColorUtils.findNearestColor((RGB)new RGB(rgb), (int)16);
        if (nearest != null) {
            boolean result = false;
            for (EnumFacing dir : sides) {
                result |= block.recolorBlock(world, pos, dir, nearest.vanillaEnum);
            }
            return result;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public static Integer getColorFromStack(@Nonnull ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b(TAG_COLOR)) {
            return tag.func_74762_e(TAG_COLOR);
        }
        return null;
    }

    public static void setColor(@Nonnull ItemStack stack, int color) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            Integer color;
            if (tintIndex == 1 && (color = ItemPaintBrush.getColorFromStack(stack)) != null) {
                return color;
            }
            return 0xFFFFFF;
        }
    }
}

