/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import openmods.geometry.Permutation2d;

public enum TextureOrientation {
    R0{

        @Override
        protected Permutation2d setup(Permutation2d input) {
            return input;
        }
    }
    ,
    R90{

        @Override
        protected Permutation2d setup(Permutation2d input) {
            return input.rotateCW();
        }
    }
    ,
    R180{

        @Override
        protected Permutation2d setup(Permutation2d input) {
            return input.reverse();
        }
    }
    ,
    R270{

        @Override
        protected Permutation2d setup(Permutation2d input) {
            return input.rotateCCW();
        }
    };

    private final Permutation2d rotator16x16 = this.setup(Permutation2d.identity((int)16, (int)16));
    private static final TextureOrientation[] VALUES;

    protected abstract Permutation2d setup(Permutation2d var1);

    public int rotate16x16(int index) {
        return this.rotator16x16.apply(index);
    }

    public TextureOrientation subtract(TextureOrientation baseRotation) {
        int id = this.ordinal() - baseRotation.ordinal();
        return VALUES[id < 0 ? id + VALUES.length : id];
    }

    public int shift(int v) {
        int id = v - this.ordinal();
        return id < 0 ? id + VALUES.length : id;
    }

    public TextureOrientation increment() {
        int id = this.ordinal() + 1;
        return VALUES[id % VALUES.length];
    }

    static {
        VALUES = TextureOrientation.values();
    }
}

