/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import it.zerono.mods.zerocore.lib.BlockFacings;
import it.zerono.mods.zerocore.lib.client.render.builder.CuboidBuilder;
import it.zerono.mods.zerocore.lib.math.Colour;
import it.zerono.mods.zerocore.lib.math.Cuboid;
import it.zerono.mods.zerocore.lib.math.LightMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ModRenderHelper {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static void bindTexture(@Nonnull ResourceLocation textureLocation) {
        ModRenderHelper.MINECRAFT.field_71446_o.func_110577_a(textureLocation);
    }

    public static void bindBlocksTexture() {
        ModRenderHelper.bindTexture(TextureMap.field_110575_b);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation location) {
        return MINECRAFT.func_147117_R().func_110572_b(location.toString());
    }

    public static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getStill());
    }

    public static TextureAtlasSprite getFluidStillSprite(FluidStack fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFluid().getStill(fluid));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFlowing());
    }

    public static TextureAtlasSprite getFluidFlowingSprite(FluidStack fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFluid().getFlowing(fluid));
    }

    @Deprecated
    public static void glSetColor(int rgbColor) {
        float r = (float)(rgbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgbColor >> 0 & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
    }

    @Deprecated
    public static void glSetColor(int rgbColor, float alpha) {
        float r = (float)(rgbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgbColor >> 0 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
    }

    public static void bufferFluidCube(@Nonnull BufferBuilder vertexBuffer, @Nonnull Cuboid cuboid, @Nonnull BlockFacings visibleFaces, @Nonnull Colour colour, @Nonnull LightMap lightMap, @Nonnull Fluid fluid) {
        CuboidBuilder builder = CuboidBuilder.getDefaultBuilder();
        TextureAtlasSprite still = ModRenderHelper.getFluidStillSprite(fluid);
        TextureAtlasSprite flowing = ModRenderHelper.getFluidFlowingSprite(fluid);
        builder.setCuboid(cuboid);
        builder.setColour(colour);
        builder.setLightMap(lightMap);
        builder.setVisibleFaces(visibleFaces);
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            if (!visibleFaces.isSet(facing)) continue;
            builder.setTexture(facing, flowing);
        }
        for (EnumFacing facing : EnumFacing.Plane.VERTICAL) {
            if (!visibleFaces.isSet(facing)) continue;
            builder.setTexture(facing, still);
        }
        builder.build().uploadVertexData(vertexBuffer);
    }

    public static void paintFluidCube(@Nonnull Cuboid cuboid, @Nonnull BlockFacings visibleFaces, @Nonnull Colour colour, @Nonnull LightMap lightMap, @Nonnull Fluid fluid) {
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ModRenderHelper.bufferFluidCube(vertexBuffer, cuboid, visibleFaces, colour, lightMap, fluid);
        RenderHelper.func_74518_a();
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.func_74519_b();
    }

    @Deprecated
    public static void renderFluidCube(Fluid fluid, BlockFacings facesToDraw, double offsetX, double offsetY, double offsetZ, double x1, double y1, double z1, double x2, double y2, double z2, int color, int brightness) {
        EnumFacing face;
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ModRenderHelper.MINECRAFT.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite still = ModRenderHelper.getTextureSprite(fluid.getStill());
        TextureAtlasSprite flowing = ModRenderHelper.getTextureSprite(fluid.getFlowing());
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
        EnumFacing[] H = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};
        EnumFacing[] V = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
        TexturedQuadData quadData = new TexturedQuadData(buffer);
        double width = x2 - x1;
        double height = y2 - y1;
        double depth = z2 - z1;
        quadData.setColor(color);
        quadData.setBrightness(brightness);
        quadData.setCoordinates(x1, y1, z1, width, height, depth, true);
        for (i = 0; i < 4; ++i) {
            face = H[i];
            if (!facesToDraw.isSet(face)) continue;
            quadData.setFace(face, flowing, true);
            ModRenderHelper.createTexturedQuad2(quadData);
        }
        quadData.setCoordinates(x1, y1, z1, width, height, depth, false);
        for (i = 0; i < 2; ++i) {
            face = V[i];
            if (!facesToDraw.isSet(face)) continue;
            quadData.setFace(face, still, false);
            ModRenderHelper.createTexturedQuad2(quadData);
        }
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @Deprecated
    public static void createTexturedQuad2(TexturedQuadData data) {
        BufferBuilder vertexes = data.vertexes;
        if (null == vertexes) {
            return;
        }
        int alpha = data.alpha;
        int red = data.red;
        int green = data.green;
        int blue = data.blue;
        int light1 = data.light1;
        int light2 = data.light2;
        switch (data.face) {
            case DOWN: {
                vertexes.func_181662_b(data.x1, data.y1, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y1, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y1, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y1, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                vertexes.func_181662_b(data.x1, data.y2, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y2, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y2, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y2, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                vertexes.func_181662_b(data.x1, data.y1, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y2, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y2, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y1, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                vertexes.func_181662_b(data.x1, data.y1, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y1, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y2, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y2, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                vertexes.func_181662_b(data.x1, data.y1, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y1, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y2, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x1, data.y2, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                vertexes.func_181662_b(data.x2, data.y1, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.maxV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y2, data.z1).func_181669_b(red, green, blue, alpha).func_187315_a(data.minU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y2, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.minV).func_187314_a(light1, light2).func_181675_d();
                vertexes.func_181662_b(data.x2, data.y1, data.z2).func_181669_b(red, green, blue, alpha).func_187315_a(data.maxU, data.maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }

    private ModRenderHelper() {
    }

    @Deprecated
    public static class TexturedQuadData {
        public final BufferBuilder vertexes;
        public int alpha;
        public int red;
        public int green;
        public int blue;
        protected double x1;
        protected double y1;
        protected double z1;
        protected double x2;
        protected double y2;
        protected double z2;
        protected double xText1;
        protected double yText1;
        protected double zText1;
        protected double xText2;
        protected double yText2;
        protected double zText2;
        protected double minU;
        protected double maxU;
        protected double minV;
        protected double maxV;
        protected int light1;
        protected int light2;
        protected EnumFacing face;

        public TexturedQuadData(BufferBuilder buffer) {
            this.vertexes = buffer;
            this.blue = 255;
            this.green = 255;
            this.red = 255;
            this.alpha = 255;
        }

        public void setBrightness(int brightness) {
            this.light1 = brightness >> 16 & 0xFFFF;
            this.light2 = brightness & 0xFFFF;
        }

        public void setColor(int color) {
            this.alpha = color >> 24 & 0xFF;
            this.red = color >> 16 & 0xFF;
            this.green = color >> 8 & 0xFF;
            this.blue = color & 0xFF;
        }

        public void setCoordinates(double x, double y, double z, double width, double height, double depth, boolean renderAsFlowingFluid) {
            this.x1 = x;
            this.x2 = x + width;
            this.y1 = y;
            this.y2 = y + height;
            this.z1 = z;
            this.z2 = z + depth;
            this.xText1 = this.x1 % 1.0;
            this.xText2 = this.xText1 + width;
            this.yText1 = this.y1 % 1.0;
            this.yText2 = this.yText1 + height;
            this.zText1 = this.z1 % 1.0;
            this.zText2 = this.zText1 + depth;
            while (this.xText2 > 1.0) {
                this.xText2 -= 1.0;
            }
            while (this.yText2 > 1.0) {
                this.yText2 -= 1.0;
            }
            while (this.zText2 > 1.0) {
                this.zText2 -= 1.0;
            }
            if (renderAsFlowingFluid) {
                double swap = 1.0 - this.yText1;
                this.yText1 = 1.0 - this.yText2;
                this.yText2 = swap;
            }
        }

        public void setFace(EnumFacing face, TextureAtlasSprite sprite, boolean renderAsFlowingFluid) {
            double textSize;
            double d = textSize = renderAsFlowingFluid ? 16.0 : 8.0;
            if (null == sprite) {
                throw new RuntimeException("No sprite set while trying to create a texture quad!");
            }
            switch (face) {
                case DOWN: 
                case UP: {
                    this.minU = sprite.func_94214_a(this.xText1 * textSize);
                    this.maxU = sprite.func_94214_a(this.xText2 * textSize);
                    this.minV = sprite.func_94207_b(this.zText1 * textSize);
                    this.maxV = sprite.func_94207_b(this.zText2 * textSize);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.minU = sprite.func_94214_a(this.xText2 * textSize);
                    this.maxU = sprite.func_94214_a(this.xText1 * textSize);
                    this.minV = sprite.func_94207_b(this.yText1 * textSize);
                    this.maxV = sprite.func_94207_b(this.yText2 * textSize);
                    break;
                }
                case WEST: 
                case EAST: {
                    this.minU = sprite.func_94214_a(this.zText2 * textSize);
                    this.maxU = sprite.func_94214_a(this.zText1 * textSize);
                    this.minV = sprite.func_94207_b(this.yText1 * textSize);
                    this.maxV = sprite.func_94207_b(this.yText2 * textSize);
                    break;
                }
                default: {
                    this.minU = sprite.func_94209_e();
                    this.maxU = sprite.func_94212_f();
                    this.minV = sprite.func_94206_g();
                    this.maxV = sprite.func_94210_h();
                }
            }
            this.face = face;
        }
    }
}

