/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import net.machinemuse.numina.energy.ElectricItemUtils;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class SprintAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public SprintAssistModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.servoMotor, (int)4));
        this.addBasePropertyDouble("sprintEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("sprintAssist", "sprintEnergyCon", 100.0);
        this.addBasePropertyDouble("sprintSpeedMult", 0.01, "%");
        this.addTradeoffPropertyDouble("sprintAssist", "sprintSpeedMult", 2.49);
        this.addBasePropertyDouble("sprintEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("compensation", "sprintEnergyCon", 20.0);
        this.addBasePropertyDouble("sprintExComp", 0.0, "%");
        this.addTradeoffPropertyDouble("compensation", "sprintExComp", 1.0);
        this.addBasePropertyDouble("walkingEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("walkingAssist", "walkingEnergyCon", 100.0);
        this.addBasePropertyDouble("walkingSpeedMult", 0.01, "%");
        this.addTradeoffPropertyDouble("walkingAssist", "walkingSpeedMult", 1.99);
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack itemStack) {
        ItemStack armorLeggings;
        if (player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA()) {
            this.onPlayerTickInactive(player, itemStack);
        }
        if (!(armorLeggings = player.func_184582_a(EntityEquipmentSlot.LEGS)).func_190926_b() && armorLeggings.func_77973_b() instanceof ItemPowerArmorLeggings) {
            double horzMovement = player.field_70140_Q - player.field_70141_P;
            double totalEnergy = ElectricItemUtils.getPlayerEnergy((EntityPlayer)player);
            if (horzMovement > 0.0) {
                if (player.func_70051_ag()) {
                    double exhaustion = (float)Math.round(horzMovement) * 0.1f;
                    double sprintCost = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "sprintEnergyCon");
                    if (sprintCost < totalEnergy) {
                        double sprintMultiplier = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "sprintSpeedMult");
                        double exhaustionComp = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "sprintExComp");
                        ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)(sprintCost * horzMovement * 5.0)));
                        MovementManager.setMovementModifier(itemStack, sprintMultiplier, player);
                        player.func_71024_bL().func_75113_a((float)(-1.0 * exhaustion * exhaustionComp));
                        player.field_70747_aH = player.func_70689_ay() * 0.2f;
                    }
                } else {
                    double cost = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "walkingEnergyCon");
                    if (cost < totalEnergy) {
                        double walkMultiplier = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "walkingSpeedMult");
                        ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)(cost * horzMovement * 5.0)));
                        MovementManager.setMovementModifier(itemStack, walkMultiplier, player);
                        player.field_70747_aH = player.func_70689_ay() * 0.2f;
                    }
                }
            }
        } else {
            this.onPlayerTickInactive(player, itemStack);
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack itemStack) {
        MovementManager.setMovementModifier(itemStack, 0.0, player);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    public String getDataName() {
        return "sprintAssist";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.sprintAssist;
    }
}

