/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.basemod.Numina;
import net.machinemuse.numina.misc.ModCompatibility;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.powersuits.common.MPSCreativeTab;
import net.machinemuse.powersuits.common.config.MPSServerSettings;
import net.machinemuse.powersuits.common.config.MPSSettings;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Keyboard;

public enum MPSConfig {
    INSTANCE;

    public static CreativeTabs mpsCreativeTab;
    private static MPSServerSettings serverSettings;
    Map<String, Double> missingModuleDoubles = new HashMap<String, Double>();
    Map<String, Integer> missingModuleIntegers = new HashMap<String, Integer>();

    @Nullable
    public static File getConfigFolder() {
        return Numina.configDir;
    }

    @Nullable
    public static final MPSServerSettings getServerSettings() {
        return serverSettings;
    }

    public static void setServerSettings(@Nullable MPSServerSettings serverSettingsIn) {
        serverSettings = serverSettingsIn;
    }

    public static double getMaximumFlyingSpeedmps() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maximumFlyingSpeedmps : MPSSettings.general.getMaximumFlyingSpeedmps;
    }

    public boolean useOldAutoFeeder() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().useOldAutoFeeder : MPSSettings.general.useOldAutoFeeder;
    }

    public static double getMaximumArmorPerPiece() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maximumArmorPerPiece : MPSSettings.general.getMaximumArmorPerPiece;
    }

    public static int rfValueOfComponent(@Nonnull ItemStack stackInCost) {
        if (!stackInCost.func_190926_b() && stackInCost.func_77973_b() instanceof ItemComponent) {
            switch (stackInCost.func_77952_i() - ItemComponent.lvcapacitor.func_77952_i()) {
                case 0: {
                    return 200000 * stackInCost.func_190916_E();
                }
                case 1: {
                    return 1000000 * stackInCost.func_190916_E();
                }
                case 2: {
                    return 7500000 * stackInCost.func_190916_E();
                }
                case 3: {
                    return 10000000 * stackInCost.func_190916_E();
                }
            }
            return 0;
        }
        return 0;
    }

    public boolean toggleModuleSpam() {
        return MPSSettings.hud.toggleModuleSpam;
    }

    public boolean keybindHUDon() {
        return MPSSettings.hud.keybindHUDon;
    }

    public double keybindHUDx() {
        return MPSSettings.hud.keybindHUDx;
    }

    public double keybindHUDy() {
        return MPSSettings.hud.keybindHUDy;
    }

    public boolean useGraphicalMeters() {
        return MPSSettings.HUD.useGraphicalMeters;
    }

    public boolean use24hClock() {
        return MPSSettings.general.use24hClock;
    }

    public boolean allowConflictingKeybinds() {
        return MPSSettings.general.allowConflictingKeybinds;
    }

    public double getSalvageChance() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().getSalvageChance : MPSSettings.general.getSalvageChance;
    }

    public static boolean doAdditionalInfo() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Keyboard.isKeyDown((int)42);
    }

    public double getBaseMaxHeat(@Nonnull ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemPowerFist) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().baseMaxHeatPowerFist : MPSSettings.general.baseMaxHeatPowerFist;
        }
        if (itemStack.func_77973_b() instanceof ItemPowerArmorHelmet) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().baseMaxHeatHelmet : MPSSettings.general.baseMaxHeatHelmet;
        }
        if (itemStack.func_77973_b() instanceof ItemPowerArmorChestplate) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().baseMaxHeatChest : MPSSettings.general.baseMaxHeatChest;
        }
        if (itemStack.func_77973_b() instanceof ItemPowerArmorLeggings) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().baseMaxHeatLegs : MPSSettings.general.baseMaxHeatLegs;
        }
        if (itemStack.func_77973_b() instanceof ItemPowerArmorBoots) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().baseMaxHeatFeet : MPSSettings.general.baseMaxHeatFeet;
        }
        return 0.0;
    }

    public boolean useThermalExpansionRecipes() {
        return ModCompatibility.isThermalExpansionLoaded() && (MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().useThermalExpansionRecipes : MPSSettings.recipesAllowed.useThermalExpansionRecipes);
    }

    public boolean useEnderIORecipes() {
        return ModCompatibility.isEnderIOLoaded() && (MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().useEnderIORecipes : MPSSettings.recipesAllowed.useEnderIORecipes);
    }

    public boolean useTechRebornRecipes() {
        return ModCompatibility.isTechRebornLoaded() && (MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().useTechRebornRecipes : MPSSettings.recipesAllowed.useTechRebornRecipes);
    }

    public boolean useIC2Recipes() {
        boolean bl;
        if (MPSConfig.getServerSettings() != null) {
            MPSConfig.getServerSettings();
            bl = MPSServerSettings.useIC2Recipes;
        } else {
            bl = MPSSettings.recipesAllowed.useIC2Recipes;
        }
        return bl;
    }

    public static int getMaxModulesOfType(EnumModuleCategory category) {
        switch (category) {
            case CATEGORY_ARMOR: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxArmorModules : MPSSettings.limits.maxArmorModules;
            }
            case CATEGORY_ENERGY_STORAGE: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxEnergyStorageModules : MPSSettings.limits.maxEnergyStorageModules;
            }
            case CATEGORY_ENERGY_GENERATION: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxEnergyGenModules : MPSSettings.limits.maxEnergyGenModules;
            }
            case CATEGORY_TOOL: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxToolModules : MPSSettings.limits.maxToolModules;
            }
            case CATEGORY_WEAPON: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxWeaponModules : MPSSettings.limits.maxWeaponModules;
            }
            case CATEGORY_MOVEMENT: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxMovementModules : MPSSettings.limits.maxMovementModules;
            }
            case CATEGORY_COSMETIC: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxCosmeticModules : MPSSettings.limits.maxCosmeticModules;
            }
            case CATEGORY_VISION: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxVisionModules : MPSSettings.limits.maxVisionModules;
            }
            case CATEGORY_ENVIRONMENTAL: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxEnvironmentalModules : MPSSettings.limits.maxEnvironmentalModules;
            }
            case CATEGORY_SPECIAL: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxSpecialModules : MPSSettings.limits.maxSpecialModules;
            }
            case CATEGORY_MINING_ENHANCEMENT: {
                return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().maxMiningEnhancementModules : MPSSettings.limits.maxMiningEnhancementModules;
            }
        }
        return 0;
    }

    public boolean getModuleAllowedorDefault(String name, boolean allowed) {
        if (Objects.equals("emptyEnhancement", name)) {
            return true;
        }
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().allowedModules.getOrDefault(name, allowed).booleanValue() : MPSSettings.modules.allowedModules.getOrDefault(name, allowed).booleanValue();
    }

    public double getPropertyDoubleOrDefault(String name, double value) {
        if (MPSConfig.getServerSettings() != null) {
            if (MPSConfig.getServerSettings().propertyDouble.isEmpty() || !MPSConfig.getServerSettings().propertyDouble.containsKey(name)) {
                System.out.println("Property config values missing: ");
                System.out.println("property: " + name);
                System.out.println("getValue: " + value);
                this.missingModuleDoubles.put(name, value);
            }
            return MPSConfig.getServerSettings().propertyDouble.getOrDefault(name, value);
        }
        if (MPSSettings.modules.propertyDouble.isEmpty() || !MPSSettings.modules.propertyDouble.containsKey(name)) {
            System.out.println("Property config values missing: ");
            System.out.println("property: " + name);
            System.out.println("getValue: " + value);
            this.missingModuleDoubles.put(name, value);
        }
        return MPSSettings.modules.propertyDouble.getOrDefault(name, value);
    }

    public int getPropertyIntegerOrDefault(String name, int value) {
        if (MPSConfig.getServerSettings() != null) {
            if (MPSConfig.getServerSettings().propertyInteger.isEmpty() || !MPSConfig.getServerSettings().propertyInteger.containsKey(name)) {
                System.out.println("Property config values missing: ");
                System.out.println("property: " + name);
                System.out.println("getValue: " + value);
                this.missingModuleIntegers.put(name, value);
            }
            return MPSConfig.getServerSettings().propertyInteger.getOrDefault(name, value);
        }
        if (MPSSettings.modules.propertyInteger.isEmpty() || !MPSSettings.modules.propertyInteger.containsKey(name)) {
            System.out.println("Property config values missing: ");
            System.out.println("property: " + name);
            System.out.println("getValue: " + value);
            this.missingModuleIntegers.put(name, value);
        }
        return MPSSettings.modules.propertyInteger.getOrDefault(name, value);
    }

    public void configDoubleKVGen() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Double> line : new TreeMap<String, Double>(this.missingModuleDoubles).entrySet()) {
            stringBuilder.append("put( \"").append(line.getKey()).append("\", ").append(line.getValue()).append("D );\n");
        }
        try {
            String output = stringBuilder.toString();
            if (output != null && !output.isEmpty()) {
                FileUtils.writeStringToFile((File)new File(MPSConfig.getConfigFolder(), "missingConfigDoubles.txt"), (String)output, (Charset)Charset.defaultCharset(), (boolean)false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configIntegerKVGen() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> line : new TreeMap<String, Integer>(this.missingModuleIntegers).entrySet()) {
            stringBuilder.append("put( \"").append(line.getKey()).append("\", ").append(line.getValue()).append("D );\n");
        }
        try {
            FileUtils.writeStringToFile((File)new File(MPSConfig.getConfigFolder(), "missingConfigIntegers.txt"), (String)stringBuilder.toString(), (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean useLegacyCosmeticSystem() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().useLegacyCosmeticSystem : MPSSettings.cosmetics.useLegacyCosmeticSystem;
    }

    public static boolean allowHighPollyArmorModels() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().allowHighPollyArmorModuels : MPSSettings.cosmetics.allowHighPollyArmorModuels;
    }

    public static boolean allowPowerFistCustomization() {
        return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().allowPowerFistCustomization : MPSSettings.cosmetics.allowPowerFistCustomization;
    }

    @Nullable
    public static NBTTagCompound getPresetNBTFor(@Nonnull ItemStack itemStack, String presetName) {
        BiMap<String, NBTTagCompound> map = MPSConfig.getCosmeticPresets(itemStack);
        return (NBTTagCompound)map.get(presetName);
    }

    public static BiMap<String, NBTTagCompound> getCosmeticPresets(@Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemPowerFist) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().cosmeticPresetsPowerFist : MPSSettings.cosmetics.getCosmeticPresetsPowerFist();
        }
        if (item instanceof ItemPowerArmorHelmet) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().cosmeticPresetsPowerArmorHelmet : MPSSettings.cosmetics.getCosmeticPresetsPowerArmorHelmet();
        }
        if (item instanceof ItemPowerArmorChestplate) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().cosmeticPresetsPowerArmorChestplate : MPSSettings.cosmetics.getCosmeticPresetsPowerArmorChestplate();
        }
        if (item instanceof ItemPowerArmorLeggings) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().cosmeticPresetsPowerArmorLeggings : MPSSettings.cosmetics.getCosmeticPresetsPowerArmorLeggings();
        }
        if (item instanceof ItemPowerArmorBoots) {
            return MPSConfig.getServerSettings() != null ? MPSConfig.getServerSettings().cosmeticPresetsPowerArmorBoots : MPSSettings.cosmetics.getCosmeticPresetsPowerArmorBoots();
        }
        return HashBiMap.create();
    }

    static {
        mpsCreativeTab = new MPSCreativeTab();
    }
}

