/* 

 csp-home.js

 Core Javascript Functions for the Client Services Platform
 home page

 ************************************************************
   (c) Copyright 2009 Marvell International Ltd.      
  
                 Marvell Confidential
 *===========================================================

 This file is intended only for the uses agreed to. 

 You are hereby notified that any dissemination, distribution or copying of 
 this material accept for the purposes agreed to is strictly prohibited.

*/

// function to show a customizable alert box
showAlert = function(left,top,title,message,isError) {
    // "alertDiv," "alertTitle," and "alertMessage" must be in the html page
    // ".alert" style must be defined in a css section
    if (isError == true) {
        document.getElementById("alertImageID").src="/_$/www/images/alert-icon.gif";
    }
    else {
        document.getElementById("alertImageID").src="/_$/www/images/info-icon.gif";
    }
    document.getElementById("alertDiv").style.left=left+'px';
    document.getElementById("alertDiv").style.top=top+'px';
    document.getElementById("alertDiv").style.display='block';
    document.getElementById("alertTitle").innerHTML = title;
    document.getElementById("alertMessage").innerHTML = message;
};

  
// don't show refresh device list completed message on initial page load
var gShowRefreshCompleted = false;

// initiate an AJAX operation to the Client Services Platform to navigate to a device with a friendly name
function navToDevice(uriEncodedName, homePage) {
  var xmlhttp;
  var xmlString;
  
  if (window.XMLHttpRequest) {
      // AJAX object creation for IE7+, Firefox, Chrome, Opera, Safari
      xmlhttp=new XMLHttpRequest();
  }
  else if (window.ActiveXObject) {
      // AJAX object creation for IE6, IE5
      xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
  else {
      showAlert(300,100,"<!--#cspi IDs CSP_HOME_TITLE_ID -->","<!--#cspi IDs CSP_NO_AJAX_SUPPORT_ID -->",true);
  }
  
  // define the needed AJAX callback function
  xmlhttp.onreadystatechange=function() {
      if(xmlhttp.readyState==4) {
          var xmlString = xmlhttp.responseText;
          document.getElementById("msgDiv").innerHTML = xmlString;
          window.open(homePage, "_self"); // nav to home page
      }
  };

  // select the device with AJAX
  xmlhttp.open("GET","/_$/service/" + uriEncodedName,true);
  xmlhttp.send(null);
}

// build a single html list entry with the device name and the Client Services Platform connect command
function makeLink(deviceName, homePage, deviceType) {

  var bulletClass = "";
  
  uriEncodedName = encodeURI(deviceName);
  
  switch(deviceType)
  {
    case "printer":
      bulletClass = "printerbullet";
      break;
    case "webserver":
      bulletClass = "serverbullet";
      break;
    default:
      bulletClass = "connectbullet";
  }
  
  
  return '<tr><td class="' + bulletClass + '"></td><td class="deviceLink"><a href="javascript:navToDevice(\'' + uriEncodedName + '\',\'' + homePage + '\');"> ' + deviceName + '</a></td></tr>';
}

// build a list of devices from the Client Services Platform XML for the user to see
function buildDeviceList(xmlString) {

  var xmlDoc = null;
  var i;
  var x;
  var links = "";
  var deviceName;
  var deviceHome;
  var deviceType;
  
  links = "<table>";

  try {//Internet Explorer
      xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
      xmlDoc.async="false";
      xmlDoc.loadXML(xmlString);
  }
  catch(e) {
      parser=new DOMParser();
      xmlDoc=parser.parseFromString(xmlString,"text/xml");
  }

  // parse device enumeration XML
  x=xmlDoc.getElementsByTagName("device");

  for (i=0;i<x.length;i++) {
      deviceName = x[i].attributes.getNamedItem("name").nodeValue
      deviceHome = x[i].attributes.getNamedItem("homeUrl").nodeValue
      deviceType = x[i].attributes.getNamedItem("type").nodeValue
      // alert(deviceName + ";" + deviceHome + ";" + deviceType);
      links += makeLink(deviceName, deviceHome, deviceType);
  }
  
  links += "</table>";
  // alert(links);
  document.getElementById("deviceList").innerHTML = links;
  
  if (gShowRefreshCompleted === true) {
      showAlert(300,100,"<!--#cspi IDs CSP_HOME_TITLE_ID -->","<!--#cspi IDs CSP_HOME_REFRESH_COMPLETED_ID -->",false);
  }
  else {
      gShowRefreshCompleted = true;
  }

}

// initiate an AJAX operation to the Client Services Platform for a fresh enumerated device list
function refreshDeviceList() {
  var xmlhttp;
  var xmlString;
  
  document.getElementById("deviceList").innerHTML = "";
    
  if (window.XMLHttpRequest) {
      // AJAX object creation for IE7+, Firefox, Chrome, Opera, Safari
      xmlhttp=new XMLHttpRequest();
  }
  else if (window.ActiveXObject) {
      // AJAX object creation for IE6, IE5
      xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
  else {
      showAlert(300,100,"<!--#cspi IDs CSP_HOME_TITLE_ID -->","<!--#cspi IDs CSP_NO_AJAX_SUPPORT_ID -->",true);
  }
  
  // define the needed AJAX callback function
  xmlhttp.onreadystatechange=function() {
      if(xmlhttp.readyState==4) {
          var xmlString = xmlhttp.responseText;
          // alert(xmlString);
          buildDeviceList(xmlString);
      }
  };

  // do the device enumeration with AJAX
  xmlhttp.open("GET","/_$/enum/services",true);
  xmlhttp.send(null);
}


// show a help message as requested by the user
function showHelpMessage() {
    showAlert(300,100,"<!--#cspi IDs CSP_HOME_TITLE_ID -->","<!--#cspi IDs CSP_HOME_HELP_MESSAGE_ID -->",false);
}