/* 

 client-tools-ex.js

 Extension to client-tools.js file for Toolbox

 ************************************************************
   (c) Copyright 2009 Marvell International Ltd.      
  
                 Marvell Confidential
 *===========================================================

 This file is intended only for the uses agreed to. 

 You are hereby notified that any dissemination, distribution or copying of 
 this material accept for the purposes agreed to is strictly prohibited.

*/
  
// a global holding the current system
var gCurrentRoot = "";

// see if we're running under the Windows O/S
function isWindowsPlatform() {
    var os = navigator.platform.toLowerCase();
    return (os.indexOf("win")!=-1) ? true:false; 
}

// initiate an AJAX operation to Lincoln get the current file system root
// for this application
function getCurrentRoot() {
  var xmlhttp;
  var xmlString;
  
  if (window.XMLHttpRequest) {
      // AJAX object creation for IE7+, Firefox, Chrome, Opera, Safari
      xmlhttp=new XMLHttpRequest();
  }
  else if (window.ActiveXObject) {
      // AJAX object creation for IE6, IE5
      xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
  else {
      alert("Your browser does not support XMLHTTP!");
  }
  
  // define the needed AJAX callback function
  xmlhttp.onreadystatechange=function() {
      if(xmlhttp.readyState==4) {
          gCurrentRoot = xmlhttp.responseText;
      }
  };

  // select the printer with AJAX
  xmlhttp.open("GET","/_$/root/",true);
  xmlhttp.send(null);
}

// initiate an AJAX operation to Lincoln to navigated to a printer with a friendly name
function launchProgram(fullProgramPath) {
  var xmlhttp;
  var xmlString;
  
  if (window.XMLHttpRequest) {
      // AJAX object creation for IE7+, Firefox, Chrome, Opera, Safari
      xmlhttp=new XMLHttpRequest();
  }
  else if (window.ActiveXObject) {
      // AJAX object creation for IE6, IE5
      xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
  else {
      alert("Your browser does not support XMLHTTP!");
  }
  
  // define the needed AJAX callback function
  xmlhttp.onreadystatechange=function() {
      if(xmlhttp.readyState==4) {
          var xmlString = xmlhttp.responseText;
      }
  };

  // select the printer with AJAX
  xmlhttp.open("GET","/_$/launch/www/" + fullProgramPath,true);
  xmlhttp.send(null);
}

// the following is where the maintenance functions will be implemented
maintFunction = function(theMaintenanceFunction) {

    var program = "toolbox/bin/shellProgram.exe";
    var args = "";
    var encodedURI = "";
    

    // alert('Client Services Platform: This function requires special PC software to execute properly.  Please review your printer installation and operation instructions to ensure this function is properly enabled.');

    if (theMaintenanceFunction === "viewManual") {
        // run the shell program to view the userManual as requested 
        
        var userManualFilePath = "<!--#cspi IDr OID_ROOT -->" + "/www/toolbox/manuals/Espresso.pdf";
        
        if (isWindowsPlatform()) {
            // flip the forward slashes in the user document path
            userManualFilePath = userManualFilePath.replace(new RegExp(/\//gi),"\\");
        }
 
        args += " opendoc";
        args += " \"" + userManualFilePath + "\"";

        encodedURI = encodeURI(program + args);
        // alert(encodedURI);
        launchProgram(encodedURI);

    } 
    else {
        // run the shell program, showing which maintenance function was requested

        args += " " + theMaintenanceFunction;

        encodedURI = encodeURI(program + args);
        // alert(encodedURI);
        launchProgram(encodedURI);

    }
    
    return true;

};

// Override the Left Nav initialization for running under Client Services
initializeLeftNav = function(myDoc) {

    // Initialize the Device Selection link for the Left-Nav Menu
    myDoc.getElementById("leftNavChooseDevice").innerHTML= "<!--#cspi IDs TOOLBOX_SELECT_DEVICE_ID -->";
    myDoc.getElementById("leftNavChooseDevice").href="javascript:pageNav('/_$/www/index.html')";

    // Initialize the maintenance function link
    myDoc.getElementById("leftNavMaint").innerHTML= "<!--#cspi IDs TOOLBOX_MAINTENANCE_ID -->";
    myDoc.getElementById("leftNavMaint").href="javascript:pageNav('/view/maint')";
};

// Override the Left Nav initialization for running under Client Services Platform
initializeLeftNav = function(myDoc) {

    var elementNode = null;
    
    // check for number of device functions
    if (gDeviceFunctionsCount == 1) {

          // take out scan and copy headings in left nav as needed
          try {
              elementNode = myDoc.getElementById("leftRowScanSettings");
              elementNode.parentNode.removeChild(elementNode);
              
              elementNode = myDoc.getElementById("leftRowCopySettings");
              elementNode.parentNode.removeChild(elementNode);

              myDoc.getElementById("leftNavPrinting").innerHTML = 'Printing';
 
          }
          catch (e) {
              // don't do any recovery
          }
    }

    // Initialize the Device Selection link for the Left-Nav Menu
    myDoc.getElementById("leftNavChooseDevice").innerHTML= "<!--#cspi IDs TOOLBOX_SELECT_DEVICE_ID -->";
    myDoc.getElementById("leftNavChooseDevice").href="javascript:pageNav('/_$/www/index.html')";

    // Initialize the maintenance function link
    myDoc.getElementById("leftNavMaint").innerHTML= "<!--#cspi IDs TOOLBOX_MAINTENANCE_ID -->";
    myDoc.getElementById("leftNavMaint").href="javascript:pageNav('/view/maint')";

};

// Override the Home Right Nav initialization for running under Client Services Platform
initializeRightNav = function(myDoc) {

    // Initialize the maintenance function link
    myDoc.getElementById("rightNavMaint").innerHTML= "<!--#cspi IDs TOOLBOX_MAINTENANCE_ID -->";
    myDoc.getElementById("rightNavMaint").href="javascript:pageNav('/view/maint')";
    myDoc.getElementById("maintenanceDesc").innerHTML= "<!--#cspi IDs TOOLBOX_MAINTENANCE_NAV_LABEL -->";
};



