/* 

 xmlTools.js

 Core Javascript Functions for the Toolbox Device / Service Selection Utility
    that handles XML file processing

 ************************************************************
   (c) Copyright 2010 Marvell International Ltd.      
  
                 Marvell Confidential
 *===========================================================

 This file is intended only for the uses agreed to. 

 You are hereby notified that any dissemination, distribution or copying of 
 this material accept for the purposes agreed to is strictly prohibited.

*/

// Dom for the entire set of configuration data
var gMyConfigDom = null;

// Dom for the entire set of services configuration data
var gServicesDom = null;

if (!this.XMLTools) { // if XMLTools not defined, define them

var XMLTools = { // put this in a closure

    makeXmlDom: function(text){ //turns xml string into DOM
        if (window.DOMParser) {
              return (new DOMParser()).parseFromString(text, "text/xml");
        }
        else if (typeof ActiveXObject != "undefined") {
         	var doc = new ActiveXObject("MSXML2.DOMDocument");      
            doc.loadXML(text);            
            return doc;                   
        } else {
            var url = "data:text/xml;charset=utf-8," + escape(text);
            var request = new XMLHttpRequest();
            request.open("GET", url, false);
            request.send(null);
            return request.responseXML;
        }
    },
    
    // parse the XML configuration file
    parseConfig: function(xmlDom) {
    
        // set pointer to global config dom
        gMyConfigDom = xmlDom;
              
        // service entry variables                
        var serviceName;
        var serviceURI;
        var homeUrl;
        var isPrinter;
        var isWebServer;
        var hasWebInterface;
        
        // html return string
        htmlReturn = "";
    
        // use jquery dom processing to march through xml returned from
        //     multiflexcsp
        
        // find the services and place into their own dom
        gServicesDom = $('service',xmlDom);

        // scan all the services in the dom
        $(gServicesDom).each(function(){
        
                // find the service name
                serviceName = $(this).find("name").text();
                
                // scan the service point elements
                hasWebInterface = false;
                
                if (serviceName.charAt(0) != '\\') { 
                    // above is Winodws shared printer check
                    // begin: device is locally-connected USB or Network
                    
                    $(this).find('servicePoint').each(function() {
                        thisId = $(this).find("id").text();
                        switch(thisId)
                        {
                            case "www":  // has a web browser service point
                              homeUrl = $(this).find("homeUrl").text();
                              serviceURI = $(this).find("uri").text();
                              hasWebInterface = true;
                              break;
                            default:
                              // alert("xmlTools: service id =", id);
                        }
                    });
                    
                    // scan the service type elements
                    isPrinter = false;
                    isWebServer = false;
                    $(this).find('type').each(function() {
                        aType = $(this).text();
                        switch(aType)
                        {
                            case "printer":  // device is a printer
                              isPrinter = true;
                              break;
                            case "web-server": // website link
                              isWebServer = true;
                              break;
                            default:
                              // alert("xmlTools: service type =", aType);
                        }
                    });
                    
                    // check to see if the current service point had a web interface
                    if (hasWebInterface == true) {
                        // check to see if the service point of interest has a printer type
                        if (isPrinter == true) {
                            // give this hyperlink entry a jquery ui printer icon
                            htmlReturn = htmlReturn + '<p><span class="ui-icon ui-icon-print anIcon"></span><a class="aLink" href="javascript:cspTwoPhaseServiceAccess(\'' + serviceURI + '\', \'/\')">' + serviceName + '</a></p>';
                        }
                        else if (isWebServer == true) {
                            // give this hyperlink entry a jquery ui link icon, and open directly in a new window
                            htmlReturn = htmlReturn + '<p><span class="ui-icon ui-icon-print anIcon"></span><a class="aLink" href="javascript:cspDirectAccess(\'' + serviceURI + '\', \'/\')">' + serviceName + '</a></p>';
                        }
                        else {
                            // give this hyperlink entry a jquery ui link icon and not a printer icon
                            htmlReturn = htmlReturn + '<p><span class="ui-icon ui-icon-link anIcon"></span><a class="aLink" href="javascript:cspTwoPhaseServiceAccess(\'' + serviceURI + '\', \'/\')">' + serviceName + '</a></p>';                
                        }
                    }
                    
                } // end: device is locally-connected USB or Network

                
        });    
        
        return htmlReturn;
    }
  
  };

}; // end of XMLTools

	 
