package mods.immibis.lxp;

import mods.immibis.core.BasicInventory;
import mods.immibis.core.api.util.BaseContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class EnchanterContainer extends BaseContainer<EnchanterTile> {

	public EnchanterContainer(EntityPlayer player, EnchanterTile inv) {
		super(player, inv);
		
		addSlotToContainer(new Slot(inv, EnchanterTile.BOOK_IN, 20, 36) {{
			setBackgroundIcon(BucketItem.bghost);
		}});
		addSlotToContainer(new Slot(inv, EnchanterTile.MEDALLION_IN, 79, 9) {{
			setBackgroundIcon(BucketItem.mghost);
		}});
		
		addSlotToContainer(new Slot(inv, EnchanterTile.TEMPLATE, 20, 75) {{
			setBackgroundIcon(BucketItem.tghost);
		}});
		
		addSlotToContainer(new Slot(inv, EnchanterTile.BOOK_OUT, 150, 36));
		addSlotToContainer(new Slot(inv, EnchanterTile.MEDALLION_OUT, 79, 75));
		
		for(int x = 0; x < 9; x++)
			addSlotToContainer(new Slot(player.inventory, x, 13 + x*18, 167));
		
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlotToContainer(new Slot(player.inventory, x+y*9+9, 13 + x*18, 109 + y*18));
	}

	@SideOnly(Side.CLIENT)
	public int getBookcases() {
		return inv.countBookshelves();
	}
	
	@Override
	public ItemStack transferStackInSlot(int slot) {
		Slot slotObj = (Slot)this.inventorySlots.get(slot);
		if(slot < 5) {
			// Transfer out of machine
			BasicInventory.mergeStackIntoRange(inv, player.inventory, slotObj.getSlotIndex(), 0, player.inventory.getSizeInventory());
		
		} else {
			// Transfer into machine, depending on item
			ItemStack stack = slotObj.getStack();
			
			// Books go into the book slot
			if(stack.getItem() == Items.book)
				BasicInventory.mergeStackIntoRange(player.inventory, inv, slot-5, EnchanterTile.BOOK_IN, EnchanterTile.BOOK_IN+1);
			// Charged medallions go into the medallion slot
			else if(stack.getItem() == LiquidXPMod.medallion && stack.getItemDamage() != 0)
				BasicInventory.mergeStackIntoRange(player.inventory, inv, slot-5, EnchanterTile.MEDALLION_IN, EnchanterTile.MEDALLION_IN+1);
			// All other items go into the template slot
			else
				BasicInventory.mergeStackIntoRange(player.inventory, inv, slot-5, EnchanterTile.TEMPLATE, EnchanterTile.TEMPLATE+1);
		}
		return null;
	}
}
