/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.util.math;

import info.ata4.minecraft.dragon.util.math.MathX;

public class Spline {
    public static final float CR00 = -0.5f;
    public static final float CR01 = 1.5f;
    public static final float CR02 = -1.5f;
    public static final float CR03 = 0.5f;
    public static final float CR10 = 1.0f;
    public static final float CR11 = -2.5f;
    public static final float CR12 = 2.0f;
    public static final float CR13 = -0.5f;
    public static final float CR20 = -0.5f;
    public static final float CR21 = 0.0f;
    public static final float CR22 = 0.5f;
    public static final float CR23 = 0.0f;
    public static final float CR30 = 0.0f;
    public static final float CR31 = 1.0f;
    public static final float CR32 = 0.0f;
    public static final float CR33 = 0.0f;

    public static float interpolateLinearEnds(float x, float ... internalKnots) {
        return Spline.interp(x, Spline.getLinearEndKnots(internalKnots));
    }

    public static float interp(float x, float ... knots) {
        int nknots = knots.length;
        int nspans = nknots - 3;
        int knot = 0;
        if (nspans < 1) {
            System.out.println(Spline.class.getName() + " Spline has too few knots");
            return 0.0f;
        }
        int span = (int)(x = MathX.clamp(x, 0.0f, 0.9999f) * (float)nspans);
        if (span >= nknots - 3) {
            span = nknots - 3;
        }
        x -= (float)span;
        float knot0 = knots[knot += span];
        float knot1 = knots[knot + 1];
        float knot2 = knots[knot + 2];
        float knot3 = knots[knot + 3];
        float c3 = -0.5f * knot0 + 1.5f * knot1 + -1.5f * knot2 + 0.5f * knot3;
        float c2 = 1.0f * knot0 + -2.5f * knot1 + 2.0f * knot2 + -0.5f * knot3;
        float c1 = -0.5f * knot0 + 0.0f * knot1 + 0.5f * knot2 + 0.0f * knot3;
        float c0 = 0.0f * knot0 + 1.0f * knot1 + 0.0f * knot2 + 0.0f * knot3;
        return ((c3 * x + c2) * x + c1) * x + c0;
    }

    public static void interp(float x, float[] result, float[] ... knots) {
        int nknots = knots.length;
        int nspans = nknots - 3;
        int knot = 0;
        if (nspans < 1) {
            System.out.println(Spline.class.getName() + " Spline has too few knots");
            return;
        }
        int span = (int)(x = MathX.clamp(x, 0.0f, 0.9999f) * (float)nspans);
        if (span >= nknots - 3) {
            span = nknots - 3;
        }
        x -= (float)span;
        knot += span;
        int dimension = result.length;
        for (int i = 0; i < dimension; ++i) {
            float knot0 = knots[knot][i];
            float knot1 = knots[knot + 1][i];
            float knot2 = knots[knot + 2][i];
            float knot3 = knots[knot + 3][i];
            float c3 = -0.5f * knot0 + 1.5f * knot1 + -1.5f * knot2 + 0.5f * knot3;
            float c2 = 1.0f * knot0 + -2.5f * knot1 + 2.0f * knot2 + -0.5f * knot3;
            float c1 = -0.5f * knot0 + 0.0f * knot1 + 0.5f * knot2 + 0.0f * knot3;
            float c0 = 0.0f * knot0 + 1.0f * knot1 + 0.0f * knot2 + 0.0f * knot3;
            result[i] = ((c3 * x + c2) * x + c1) * x + c0;
        }
    }

    public static float[] interpArray(float[] inputs, float ... knots) {
        float[] result = new float[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            result[i] = Spline.interp(inputs[i], knots);
        }
        return result;
    }

    public static float[] interpEndsArray(float[] inputs, float ... internalKnots) {
        float[] knots = Spline.getLinearEndKnots(internalKnots);
        float[] result = new float[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            result[i] = Spline.interp(inputs[i], knots);
        }
        return result;
    }

    public static float[] interpLinearEndsArray(float minInputValue, float maxInputValue, int n, float ... internalKnots) {
        float[] inputs = new float[n];
        float stepLength = (maxInputValue - minInputValue) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            inputs[i] = minInputValue + (float)i * stepLength;
        }
        return Spline.interpEndsArray(inputs, internalKnots);
    }

    public static float[] interpLinearEndsArray(int n, float ... internalKnots) {
        return Spline.interpLinearEndsArray(0.0f, 1.0f, n, internalKnots);
    }

    public static float[] getLinearEndKnots(float ... internalKnots) {
        float[] result = new float[internalKnots.length + 2];
        float diff1 = internalKnots[1] - internalKnots[0];
        float diff2 = internalKnots[internalKnots.length - 1] - internalKnots[internalKnots.length - 2];
        result[0] = internalKnots[0] - diff1;
        result[result.length - 1] = internalKnots[internalKnots.length - 1] + diff2;
        for (int i = 1; i < result.length - 1; ++i) {
            result[i] = internalKnots[i - 1];
        }
        return result;
    }
}

