/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import cpw.mods.fml.relauncher.ReflectionHelper;
import info.ata4.minecraft.dragon.server.entity.ai.DragonFlightWaypoint;
import info.ata4.minecraft.dragon.util.math.MathX;
import info.ata4.minecraft.dragon.util.reflection.PrivateFields;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EntityFlyingTameable
extends EntityTameable {
    private static final Logger L = LogManager.getLogger();
    private static final int IN_AIR_THRESH = 10;
    public static final IAttribute MOVE_SPEED_AIR = new RangedAttribute("generic.movementSpeedAir", 1.5, 0.0, Double.MAX_VALUE).func_111117_a("Movement Speed Air").func_111112_a(true);
    private static final int INDEX_FLYING = 18;
    private static final int INDEX_CAN_FLY = 19;
    private static String NBT_FLYING = "Flying";
    private static String NBT_CAN_FLY = "CanFly";
    public EntityAITasks airTasks;
    private DragonFlightWaypoint waypoint = new DragonFlightWaypoint((Entity)this);
    private double airSpeedHorizonal = 1.5;
    private double airSpeedVertical = 0.0;
    private float yawAdd;
    private int yawSpeed = 30;
    private int inAirTicks;

    public EntityFlyingTameable(World world) {
        super(world);
        this.airTasks = new EntityAITasks(world != null ? world.field_72984_F : null);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(MOVE_SPEED_AIR);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a(NBT_FLYING, this.isFlying());
        nbt.func_74757_a(NBT_CAN_FLY, this.isCanFly());
        this.waypoint.writeToNBT(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFlying(nbt.func_74767_n(NBT_FLYING));
        this.setCanFly(nbt.func_74767_n(NBT_CAN_FLY));
        this.waypoint.readFromNBT(nbt);
    }

    protected void func_70069_a(float par1) {
        if (!this.isCanFly()) {
            super.func_70069_a(par1);
        }
    }

    public void liftOff() {
        L.trace("liftOff");
        if (this.isCanFly()) {
            this.func_70664_aZ();
            this.field_70181_x += 0.5;
            this.inAirTicks += 20;
            this.waypoint.clear();
        }
    }

    private void setTasksEnabled(EntityAITasks tasks, boolean flag) {
        ReflectionHelper.setPrivateValue(EntityAITasks.class, (Object)tasks, (Object)(flag ? 3 : Integer.MAX_VALUE), (String[])PrivateFields.ENTITYAITASKS_TICKRATE);
    }

    protected boolean isGroundAIEnabled() {
        return !this.isFlying();
    }

    protected boolean isAirAIEnabled() {
        return this.isFlying();
    }

    protected void func_70619_bc() {
        this.setTasksEnabled(this.field_70714_bg, this.isGroundAIEnabled());
        this.setTasksEnabled(this.airTasks, this.isAirAIEnabled());
        super.func_70619_bc();
        this.airTasks.func_75774_a();
    }

    public void func_70636_d() {
        if (!this.isCanFly()) {
            if (this.isFlying()) {
                this.setFlying(false);
            }
            super.func_70636_d();
            return;
        }
        if (this.isServer()) {
            this.inAirTicks = !this.field_70122_E ? ++this.inAirTicks : 0;
            this.setFlying(this.inAirTicks > 10);
        }
        if (this.isFlying()) {
            if (this.isClient()) {
                this.onUpdateFlyingClient();
            } else {
                this.onUpdateFlyingServer();
            }
        } else {
            super.func_70636_d();
        }
    }

    private void onUpdateFlyingClient() {
        if (this.field_70716_bi > 0) {
            double px = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
            double py = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
            double pz = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
            double newYaw = MathX.normDeg(this.field_70712_bm - (double)this.field_70177_z);
            this.field_70177_z += (float)newYaw / (float)this.field_70716_bi;
            this.field_70125_A += ((float)this.field_70705_bn - this.field_70125_A) / (float)this.field_70716_bi;
            --this.field_70716_bi;
            this.func_70107_b(px, py, pz);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void onUpdateFlyingServer() {
        float friction = 0.0f;
        if (!this.waypoint.isNear()) {
            double deltaX = (double)this.waypoint.posX - this.field_70165_t;
            double deltaY = (double)this.waypoint.posY - this.field_70163_u;
            double deltaZ = (double)this.waypoint.posZ - this.field_70161_v;
            double speedAir = this.func_110148_a(MOVE_SPEED_AIR).func_111126_e();
            double speedHoriz = this.airSpeedHorizonal * speedAir;
            double speedVert = this.airSpeedVertical;
            deltaY /= Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            deltaY = MathX.clamp(deltaY, -speedHoriz, speedHoriz) / 3.0;
            double motionHypot = Math.hypot(this.field_70159_w, this.field_70179_y) + 1.0;
            double newYaw = Math.toDegrees(Math.PI * 2 - Math.atan2(deltaX, deltaZ));
            double yawDelta = MathX.normDeg(newYaw - (double)this.field_70177_z);
            yawDelta = MathX.clamp(yawDelta, (double)(-this.yawSpeed), (double)this.yawSpeed);
            this.yawAdd *= 0.8f;
            this.yawAdd = (float)((double)this.yawAdd + yawDelta * (0.7 / motionHypot));
            this.field_70177_z += this.yawAdd * 0.1f;
            Vec3 motionVec = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
            Vec3 deltaVec = Vec3.func_72443_a((double)deltaX, (double)deltaY, (double)deltaZ).func_72432_b();
            Vec3 rotVec = Vec3.func_72443_a((double)(-Math.sin(Math.toRadians(this.field_70177_z))), (double)this.field_70181_x, (double)Math.cos(Math.toRadians(this.field_70177_z))).func_72432_b();
            float tmp1 = (float)(rotVec.func_72430_b(deltaVec) + 0.5) / 1.5f;
            if (tmp1 < 0.0f) {
                tmp1 = 0.0f;
            }
            float tmp2 = (float)(2.0 / (motionHypot + 1.0));
            float acc = 0.06f * (tmp1 * tmp2 + (1.0f - tmp2));
            this.field_70181_x = deltaY + speedVert;
            this.func_70060_a(0.0f, (float)speedHoriz, acc);
            friction = (float)(motionVec.func_72430_b(rotVec) + 1.0) / 2.0f;
        }
        friction = 0.8f + 0.15f * friction;
        if (this.field_70171_ac) {
            friction *= 0.8f;
        }
        this.field_70159_w *= (double)friction;
        this.field_70181_x *= (double)friction;
        this.field_70179_y *= (double)friction;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.func_70650_aV()) {
            this.field_70170_p.field_72984_F.func_76320_a("newAi");
            this.func_70619_bc();
            this.field_70170_p.field_72984_F.func_76319_b();
        } else {
            this.field_70170_p.field_72984_F.func_76320_a("oldAi");
            this.func_70626_be();
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70759_as = this.field_70177_z;
        }
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.0));
        if (entities != null && !entities.isEmpty()) {
            for (Entity entity : entities) {
                if (!entity.func_70104_M()) continue;
                entity.func_70108_f((Entity)this);
            }
        }
    }

    public boolean isFlying() {
        return (this.field_70180_af.func_75683_a(18) & 1) != 0;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_75692_b(18, (Object)(flying ? (byte)1 : 0));
    }

    public boolean isCanFly() {
        return (this.field_70180_af.func_75683_a(19) & 1) != 0;
    }

    public void setCanFly(boolean canFly) {
        L.trace("setCanFly({})", new Object[]{canFly});
        this.field_70180_af.func_75692_b(19, (Object)(canFly ? (byte)1 : 0));
    }

    public double getAltitude() {
        int blockX = (int)(this.field_70165_t - 0.5);
        int blockZ = (int)(this.field_70161_v - 0.5);
        return this.field_70163_u - (double)this.field_70170_p.func_72976_f(blockX, blockZ);
    }

    public DragonFlightWaypoint getWaypoint() {
        return this.waypoint;
    }

    public double getMoveSpeedAirHoriz() {
        return this.airSpeedHorizonal;
    }

    public void setMoveSpeedAirHoriz(double airSpeedHorizonal) {
        L.trace("setMoveSpeedAirHoriz({})", new Object[]{airSpeedHorizonal});
        this.airSpeedHorizonal = airSpeedHorizonal;
    }

    public double getMoveSpeedAirVert() {
        return this.airSpeedVertical;
    }

    public void setMoveSpeedAirVert(double airSpeedVertical) {
        L.trace("setMoveSpeedAirVert({})", new Object[]{airSpeedVertical});
        this.airSpeedVertical = airSpeedVertical;
    }

    public boolean isClient() {
        return this.field_70170_p.field_72995_K;
    }

    public boolean isServer() {
        return !this.field_70170_p.field_72995_K;
    }
}

