/*
 * Decompiled with CFR 0.152.
 */
package dalapo.autoutils.tileentity;

import dalapo.autoutils.helper.TileEntityHelper;
import dalapo.autoutils.logging.Logger;
import dalapo.autoutils.reference.UsefulLists;
import dalapo.autoutils.tileentity.ActionOnRedstone;
import dalapo.autoutils.tileentity.TileEntityBasicInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStackMover
extends TileEntityBasicInventory
implements ISidedInventory,
ActionOnRedstone {
    private boolean isPowered = false;
    public static final String id = "StackMover";
    private int filterSlot = 0;

    public TileEntityStackMover() {
        super(9, "stackmover");
    }

    @Override
    public void performAction() {
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (!this.isPowered) {
                Logger.info("About to enter transferStack()");
                this.transferStack();
                this.isPowered = true;
            }
        } else {
            this.isPowered = false;
        }
    }

    @Override
    public String getDisplayName() {
        return "Filter";
    }

    private boolean shouldFilter() {
        for (int i = 0; i < 9; ++i) {
            if (this.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    private int checkFilter(ItemStack is) {
        if (!this.shouldFilter()) {
            return 9;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(is)) continue;
            return i;
        }
        return -1;
    }

    private int[] getSlot(IInventory te, IInventory dest, int side, boolean insert) {
        if (te == null) {
            return null;
        }
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            ItemStack wouldMove;
            if (!insert && te.func_70301_a(i) == null) continue;
            int filterSlot = this.checkFilter(te.func_70301_a(i));
            if (!TileEntityHelper.isValidSlotForSide(te, side, i) || te.func_70301_a(i) == null || filterSlot == -1 || !TileEntityHelper.hasSpaceForItem(dest, wouldMove = te.func_70301_a(i), ForgeDirection.OPPOSITES[side])) continue;
            return new int[]{filterSlot, i};
        }
        return null;
    }

    public void transferStack() {
        ForgeDirection front = UsefulLists.directions[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) % 6];
        TileEntity pull = this.field_145850_b.func_147438_o(this.field_145851_c + front.offsetX, this.field_145848_d + front.offsetY, this.field_145849_e + front.offsetZ);
        TileEntity push = this.field_145850_b.func_147438_o(this.field_145851_c - front.offsetX, this.field_145848_d - front.offsetY, this.field_145849_e - front.offsetZ);
        if (!(pull instanceof IInventory)) {
            return;
        }
        int[] pair = this.getSlot((IInventory)pull, (IInventory)push, ForgeDirection.OPPOSITES[front.ordinal()], false);
        if (pair == null) {
            return;
        }
        int moveSize = pair[0] == 9 ? 64 : this.func_70301_a((int)pair[0]).field_77994_a;
        ItemStack toMove = ((IInventory)pull).func_70298_a(pair[1], moveSize);
        if (!(push instanceof IInventory)) {
            EntityItem drop = new EntityItem(this.field_145850_b, (double)(this.field_145851_c - front.offsetX) + 0.5, (double)(this.field_145848_d - front.offsetY) + 0.5, (double)(this.field_145849_e - front.offsetZ) + 0.5, toMove);
            this.field_145850_b.func_72838_d((Entity)drop);
        }
        if (push != null && push instanceof IInventory) {
            ItemStack remaining = TileEntityHelper.tryInsertItem((IInventory)push, toMove, front.ordinal());
            if (((IInventory)pull).func_70301_a(pair[1]) == null) {
                ((IInventory)pull).func_70299_a(pair[1], remaining);
            } else {
                ItemStack is = ((IInventory)pull).func_70301_a(pair[1]);
                if (remaining != null) {
                    is.field_77994_a += remaining.field_77994_a;
                }
                ((IInventory)pull).func_70299_a(pair[1], is);
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return 9;
    }

    @Override
    public String func_145825_b() {
        return "Filter";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public int[] func_94128_d(int side) {
        return null;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }
}

